/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.CurrencyResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field11A
extends Field
implements Serializable,
CurrencyContainer,
GenericField {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "11A";
    public static final String F_11A = "11A";
    public static final String PARSER_PATTERN = ":S//S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SC";
    public static final String TYPES_PATTERN = "SC";
    public static final Integer QUALIFIER = 1;
    public static final Integer CURRENCY_CODE = 2;
    @Deprecated
    public static final Integer CURRENCY = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field11A() {
        super(2);
    }

    public Field11A(String value) {
        super(value);
    }

    public Field11A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"11A")) {
            throw new IllegalArgumentException("cannot create field 11A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field11A newInstance(Field11A source) {
        Field11A cp = new Field11A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("11A", value);
    }

    public static Tag emptyTag() {
        return new Tag("11A", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "//"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 11A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public final String componentsPattern() {
        return "SC";
    }

    @Override
    public final String typesPattern() {
        return "SC";
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<CUR>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    protected List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Currency Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "currencyCode");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrencyCode() {
        return this.getComponent2();
    }

    @Deprecated
    public String getCurrency() {
        return this.getCurrencyCode();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent2AsCurrency();
    }

    @Deprecated
    public Currency getCurrencyAsCurrency() {
        return this.getCurrencyCodeAsCurrency();
    }

    public Field11A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field11A setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field11A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field11A setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field11A setCurrencyCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field11A setCurrencyCode(Currency component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field11A setCurrency(String component2) {
        return this.setCurrencyCode(component2);
    }

    @Deprecated
    public Field11A setCurrency(Currency component2) {
        return this.setCurrencyCode(component2);
    }

    @Override
    public List<String> currencyStrings() {
        return CurrencyResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return CurrencyResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return CurrencyResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return CurrencyResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        CurrencyResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "11A";
    }

    public static Field11A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("11A");
        if (t == null) {
            return null;
        }
        return new Field11A(t);
    }

    public static Field11A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field11A.get(msg.getBlock4());
    }

    public static List<Field11A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field11A.getAll(msg.getBlock4());
    }

    public static List<Field11A> getAll(SwiftTagListBlock block) {
        ArrayList<Field11A> result = new ArrayList<Field11A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("11A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field11A(f));
            }
        }
        return result;
    }

    public static Field11A fromJson(String json) {
        Field11A field = new Field11A();
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = (JsonObject)parser.parse(json);
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent2(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent2(jsonObject.get("currencyCode").getAsString());
        }
        return field;
    }
}

