/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field61;
import com.prowidesoftware.swift.model.field.Narrative;
import com.prowidesoftware.swift.model.field.StructuredNarrative;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.IsoUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.apache.commons.lang3.tuple.Triple;

public class NarrativeResolver {
    private static final transient Logger log = Logger.getLogger(NarrativeResolver.class.getName());
    private static final int CODEWORDTYPE_UCASE = 1;
    private static final int CODEWORDTYPE_UCASE_NUMBER = 2;
    private static final int CODEWORDTYPE_NUMBER = 3;

    public static Narrative parse(Field f) {
        switch (f.getName()) {
            case "77A": 
            case "74": 
            case "86": {
                return NarrativeResolver.parseFormat1(f);
            }
            case "72Z": 
            case "72": 
            case "77": 
            case "77J": {
                return NarrativeResolver.parseFormat2(f);
            }
            case "73A": 
            case "71D": 
            case "71B": 
            case "73": {
                return NarrativeResolver.parseFormat3(f);
            }
            case "77B": {
                return NarrativeResolver.parseFormat4(f);
            }
            case "75": 
            case "76": {
                return NarrativeResolver.parseFormat5(f);
            }
            case "49N": 
            case "45B": 
            case "46B": 
            case "49M": {
                return NarrativeResolver.parseFormat6(f);
            }
            case "70": 
            case "77D": 
            case "37N": {
                return NarrativeResolver.parseFormat7(f);
            }
            case "29A": 
            case "79": {
                return NarrativeResolver.parseFormat8(f.getValue());
            }
            case "61": {
                Field61 field61 = (Field61)f;
                return NarrativeResolver.parseFormat8(field61.getSupplementaryDetails());
            }
        }
        log.warning("Don't know how to parse structured narrative line formats for " + f.getName());
        return new Narrative();
    }

    private static Narrative parseFormat(Field f, int codewordMaxSize, int codewordType, boolean supportsCountry, boolean supportsCurrency, boolean supportsSupplement, boolean additionalNarrativesStartWithDoubleSlash) {
        Narrative narrative = new Narrative();
        String value = f.getValue();
        boolean unstructuredSection = !value.startsWith("/") || value.startsWith("//");
        StructuredNarrative structured = null;
        boolean firstSupplementAdded = false;
        for (String line : NarrativeResolver.notEmptyLines(value)) {
            if (unstructuredSection) {
                narrative.addUnstructuredFragment(line);
                continue;
            }
            unstructuredSection = true;
            if (line.charAt(0) == '/') {
                if (line.length() > 1 && line.charAt(1) == '/') {
                    unstructuredSection = false;
                    if (additionalNarrativesStartWithDoubleSlash) {
                        line = line.substring(2);
                        if (supportsSupplement) {
                            firstSupplementAdded = NarrativeResolver.addNarrativeSupplement(firstSupplementAdded, line, structured);
                        } else if (StringUtils.isNotEmpty((CharSequence)line)) {
                            structured.addNarrativeFragment(line);
                        }
                    } else {
                        structured.addNarrativeFragment(line);
                    }
                } else {
                    String codeword = StringUtils.substringBetween((String)line, (String)"/", (String)"/");
                    if (NarrativeResolver.isCodewordValid(codeword, codewordType, codewordMaxSize)) {
                        String country;
                        firstSupplementAdded = false;
                        unstructuredSection = false;
                        structured = new StructuredNarrative().setCodeword(codeword);
                        String text = StringUtils.substringAfter((String)line, (String)(codeword + "/"));
                        if (supportsCountry && (country = NarrativeResolver.getCountry(StringUtils.substringBefore((String)text, (String)"//"))) != null) {
                            structured.setCountry(country);
                            text = StringUtils.substringAfter((String)text, (String)"//");
                        }
                        if (supportsCurrency) {
                            Triple<String, BigDecimal, String> tripleValue = NarrativeResolver.getCurrencyAmountAndNarrative(text);
                            String currency = (String)tripleValue.getLeft();
                            BigDecimal amount = (BigDecimal)tripleValue.getMiddle();
                            String narrativeFragment = (String)tripleValue.getRight();
                            if (currency != null) {
                                structured.setCurrency(currency);
                                if (amount != null) {
                                    structured.setAmount(amount);
                                }
                            }
                            text = narrativeFragment;
                        }
                        if (supportsSupplement) {
                            firstSupplementAdded = NarrativeResolver.addNarrativeSupplement(firstSupplementAdded, text, structured);
                        } else if (StringUtils.isNotEmpty((CharSequence)text)) {
                            structured.addNarrativeFragment(text);
                        }
                        narrative.add(structured);
                    } else if (!additionalNarrativesStartWithDoubleSlash && structured != null) {
                        structured.addNarrativeFragment(line);
                        unstructuredSection = false;
                    }
                }
            } else if (!additionalNarrativesStartWithDoubleSlash && structured != null) {
                structured.addNarrativeFragment(line);
                unstructuredSection = false;
            }
            if (!unstructuredSection) continue;
            narrative.addUnstructuredFragment(line);
        }
        return narrative;
    }

    private static List<String> notEmptyLines(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        lines.removeIf(item -> item == null || item.isEmpty());
        return lines;
    }

    private static boolean addNarrativeSupplement(boolean firstSupplementAdded, String line, StructuredNarrative structured) {
        if (!firstSupplementAdded) {
            String text = StringUtils.substringBefore((String)line, (String)"/");
            if (StringUtils.isNotEmpty((CharSequence)text)) {
                structured.addNarrativeFragment(text);
            }
            if (StringUtils.isNotEmpty((CharSequence)(text = StringUtils.substringAfter((String)line, (String)"/")))) {
                structured.addNarrativeSupplementFragment(text);
                return true;
            }
        } else if (StringUtils.isNotEmpty((CharSequence)line)) {
            structured.addNarrativeSupplementFragment(line);
        }
        return firstSupplementAdded;
    }

    public static Narrative parseFreeFormat(String value) {
        Narrative narrative = new Narrative();
        if (value == null) {
            return narrative;
        }
        boolean structured = value.startsWith("/") && NarrativeResolver.isCodewordValid(StringUtils.substringBefore((String)value.substring(1), (String)"/"), 1, -1);
        List<String> lines = NarrativeResolver.notEmptyLines(value);
        if (structured) {
            String[] tokens = String.join((CharSequence)"", lines).split("/");
            String currentCodeword = null;
            StringBuilder currentText = new StringBuilder();
            for (String token : tokens) {
                if (NarrativeResolver.isCodewordValid(token, 1, -1)) {
                    if (currentCodeword != null) {
                        NarrativeResolver.add(narrative, currentCodeword, currentText.toString());
                    }
                    currentCodeword = token;
                    currentText = new StringBuilder();
                    continue;
                }
                if (currentText.length() > 0) {
                    currentText.append("/");
                }
                currentText.append(token);
            }
            if (currentCodeword != null) {
                NarrativeResolver.add(narrative, currentCodeword, currentText.toString());
            }
        } else {
            for (String line : lines) {
                narrative.addUnstructuredFragment(line);
            }
        }
        return narrative;
    }

    private static void add(Narrative narrative, String codeword, String text) {
        StructuredNarrative item = new StructuredNarrative().setCodeword(codeword);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{text})) {
            item.addNarrativeFragment(text);
        }
        narrative.add(item);
    }

    private static boolean isCodewordValid(String codeword, int codewordType, int codewordMaxSize) {
        if (StringUtils.isEmpty((CharSequence)codeword)) {
            return false;
        }
        codeword = StringUtils.trimToEmpty((String)codeword);
        if (codewordMaxSize > 0 && codeword.length() > codewordMaxSize) {
            return false;
        }
        for (int i = 0; i < codeword.length(); ++i) {
            char c = codeword.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                return false;
            }
            if (Character.isLowerCase(c) && (codewordType == 1 || codewordType == 2)) {
                return false;
            }
            if (Character.isLetter(c) && codewordType == 3) {
                return false;
            }
            if (!Character.isDigit(c) || codewordType != 1) continue;
            return false;
        }
        return true;
    }

    private static String getCountry(String text) {
        text = StringUtils.trimToEmpty((String)text);
        if (!IsoUtils.getInstance().isValidISOCountry(text)) {
            return null;
        }
        return text;
    }

    private static Triple<String, BigDecimal, String> getCurrencyAmountAndNarrative(String text) {
        StringBuilder currency = new StringBuilder();
        StringBuilder amount = new StringBuilder();
        StringBuilder narrative = new StringBuilder();
        int section = 1;
        text = StringUtils.trimToEmpty((String)text);
        block5: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (section) {
                case 1: {
                    if (Character.isDigit(c)) {
                        section = 2;
                        amount.append(c);
                        continue block5;
                    }
                    currency.append(c);
                    continue block5;
                }
                case 2: {
                    if (Character.isDigit(c) || c == '.' || c == ',') {
                        amount.append(c == ',' ? (char)'.' : (char)c);
                        continue block5;
                    }
                    section = 3;
                    narrative.append(c);
                    continue block5;
                }
                case 3: {
                    narrative.append(c);
                }
            }
        }
        return new ImmutableTriple((Object)(currency.length() == 0 ? null : currency.toString()), (Object)(amount.length() == 0 ? null : new BigDecimal(amount.toString())), (Object)(narrative.length() == 0 ? null : narrative.toString()));
    }

    public static Narrative parseFormat1(Field f) {
        return NarrativeResolver.parseFormat(f, 8, 1, false, false, false, true);
    }

    public static Narrative parseFormat2(Field f) {
        return NarrativeResolver.parseFormat(f, 8, 2, false, false, false, true);
    }

    public static Narrative parseFormat3(Field f) {
        return NarrativeResolver.parseFormat(f, 8, 2, false, true, false, true);
    }

    public static Narrative parseFormat4(Field f) {
        return NarrativeResolver.parseFormat(f, 8, 2, true, false, false, true);
    }

    public static Narrative parseFormat5(Field f) {
        return NarrativeResolver.parseFormat(f, 2, 3, false, false, true, true);
    }

    public static Narrative parseFormat6(Field f) {
        return NarrativeResolver.parseFormat(f, 6, 2, false, false, false, false);
    }

    public static Narrative parseFormat7(Field f) {
        return NarrativeResolver.parseFormat(f, -1, 1, false, false, false, true);
    }

    public static Narrative parseFormat8(String value) {
        return NarrativeResolver.parseFreeFormat(value);
    }
}

