/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field102;
import com.prowidesoftware.swift.model.field.Field103;
import com.prowidesoftware.swift.model.field.Field106;
import com.prowidesoftware.swift.model.field.Field108;
import com.prowidesoftware.swift.model.field.Field114;
import com.prowidesoftware.swift.model.field.Field175;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT012
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT012.class.getName());
    public static final String NAME = "012";

    public MT012(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT012(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT012 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT012(m);
    }

    public MT012() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT012(String sender, String receiver) {
        super(12, sender, receiver);
    }

    public MT012(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT012.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT012 object from FIN content with a Service Message. Check if the MT012 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT012 object from FIN content with message type " + param.getType());
        }
    }

    public static MT012 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT012(fin);
    }

    public MT012(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT012 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT012(stream);
    }

    public MT012(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT012 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT012(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT012 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT012 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT012 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT012 fromJson(String json) {
        return (MT012)AbstractMT.fromJson(json);
    }

    public Field175 getField175() {
        Tag t = this.tag("175");
        if (t != null) {
            return new Field175(t.getValue());
        }
        return null;
    }

    public Field106 getField106() {
        Tag t = this.tag("106");
        if (t != null) {
            return new Field106(t.getValue());
        }
        return null;
    }

    public Field108 getField108() {
        Tag t = this.tag("108");
        if (t != null) {
            return new Field108(t.getValue());
        }
        return null;
    }

    public Field102 getField102() {
        Tag t = this.tag("102");
        if (t != null) {
            return new Field102(t.getValue());
        }
        return null;
    }

    public Field103 getField103() {
        Tag t = this.tag("103");
        if (t != null) {
            return new Field103(t.getValue());
        }
        return null;
    }

    public Field114 getField114() {
        Tag t = this.tag("114");
        if (t != null) {
            return new Field114(t.getValue());
        }
        return null;
    }
}

