/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field304;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT042
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT042.class.getName());
    public static final String NAME = "042";

    public MT042(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT042(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT042 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT042(m);
    }

    public MT042() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT042(String sender, String receiver) {
        super(42, sender, receiver);
    }

    public MT042(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT042.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT042 object from FIN content with a Service Message. Check if the MT042 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT042 object from FIN content with message type " + param.getType());
        }
    }

    public static MT042 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT042(fin);
    }

    public MT042(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT042 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT042(stream);
    }

    public MT042(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT042 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT042(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT042 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT042 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT042 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT042 fromJson(String json) {
        return (MT042)AbstractMT.fromJson(json);
    }

    public Field304 getField304() {
        Tag t = this.tag("304");
        if (t != null) {
            return new Field304(t.getValue());
        }
        return null;
    }
}

