/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field209;
import com.prowidesoftware.swift.model.field.Field251;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT070
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT070.class.getName());
    public static final String NAME = "070";

    public MT070(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT070(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT070 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT070(m);
    }

    public MT070() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT070(String sender, String receiver) {
        super(70, sender, receiver);
    }

    public MT070(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT070.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT070 object from FIN content with a Service Message. Check if the MT070 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT070 object from FIN content with message type " + param.getType());
        }
    }

    public static MT070 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT070(fin);
    }

    public MT070(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT070 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT070(stream);
    }

    public MT070(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT070 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT070(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT070 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT070 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT070 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT070 fromJson(String json) {
        return (MT070)AbstractMT.fromJson(json);
    }

    public Field251 getField251() {
        Tag t = this.tag("251");
        if (t != null) {
            return new Field251(t.getValue());
        }
        return null;
    }

    public Field209 getField209() {
        Tag t = this.tag("209");
        if (t != null) {
            return new Field209(t.getValue());
        }
        return null;
    }
}

