/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt1xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftBlock4;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field19;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field21C;
import com.prowidesoftware.swift.model.field.Field21D;
import com.prowidesoftware.swift.model.field.Field21E;
import com.prowidesoftware.swift.model.field.Field21R;
import com.prowidesoftware.swift.model.field.Field23E;
import com.prowidesoftware.swift.model.field.Field26T;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32B;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field36;
import com.prowidesoftware.swift.model.field.Field50A;
import com.prowidesoftware.swift.model.field.Field50C;
import com.prowidesoftware.swift.model.field.Field50K;
import com.prowidesoftware.swift.model.field.Field50L;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field52A;
import com.prowidesoftware.swift.model.field.Field52C;
import com.prowidesoftware.swift.model.field.Field52D;
import com.prowidesoftware.swift.model.field.Field53A;
import com.prowidesoftware.swift.model.field.Field53B;
import com.prowidesoftware.swift.model.field.Field57A;
import com.prowidesoftware.swift.model.field.Field57C;
import com.prowidesoftware.swift.model.field.Field57D;
import com.prowidesoftware.swift.model.field.Field59;
import com.prowidesoftware.swift.model.field.Field59A;
import com.prowidesoftware.swift.model.field.Field70;
import com.prowidesoftware.swift.model.field.Field71A;
import com.prowidesoftware.swift.model.field.Field71F;
import com.prowidesoftware.swift.model.field.Field71G;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field77B;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT104
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT104.class.getName());
    public static final String NAME = "104";

    public MT104(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT104(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT104 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT104(m);
    }

    public MT104() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT104(String sender, String receiver) {
        super(104, sender, receiver);
    }

    public MT104(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT104.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT104 object from FIN content with a Service Message. Check if the MT104 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT104 object from FIN content with message type " + param.getType());
        }
    }

    public static MT104 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT104(fin);
    }

    public MT104(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT104 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT104(stream);
    }

    public MT104(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT104 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT104(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT104 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT104 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT104 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT104 fromJson(String json) {
        return (MT104)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21R getField21R() {
        Tag t = this.tag("21R");
        if (t != null) {
            return new Field21R(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public Field51A getField51A() {
        Tag t = this.tag("51A");
        if (t != null) {
            return new Field51A(t.getValue());
        }
        return null;
    }

    public Field72 getField72() {
        Tag t = this.tag("72");
        if (t != null) {
            return new Field72(t.getValue());
        }
        return null;
    }

    public Field19 getField19() {
        Tag t = this.tag("19");
        if (t != null) {
            return new Field19(t.getValue());
        }
        return null;
    }

    public Field53A getField53A() {
        Tag t = this.tag("53A");
        if (t != null) {
            return new Field53A(t.getValue());
        }
        return null;
    }

    public Field53B getField53B() {
        Tag t = this.tag("53B");
        if (t != null) {
            return new Field53B(t.getValue());
        }
        return null;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field23E> getField23E() {
        ArrayList<Field23E> result = new ArrayList<Field23E>();
        Tag[] tags = this.tags("23E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field23E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21C> getField21C() {
        ArrayList<Field21C> result = new ArrayList<Field21C>();
        Tag[] tags = this.tags("21C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21D> getField21D() {
        ArrayList<Field21D> result = new ArrayList<Field21D>();
        Tag[] tags = this.tags("21D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21E> getField21E() {
        ArrayList<Field21E> result = new ArrayList<Field21E>();
        Tag[] tags = this.tags("21E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32B> getField32B() {
        ArrayList<Field32B> result = new ArrayList<Field32B>();
        Tag[] tags = this.tags("32B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50C> getField50C() {
        ArrayList<Field50C> result = new ArrayList<Field50C>();
        Tag[] tags = this.tags("50C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50L> getField50L() {
        ArrayList<Field50L> result = new ArrayList<Field50L>();
        Tag[] tags = this.tags("50L");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50L(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50A> getField50A() {
        ArrayList<Field50A> result = new ArrayList<Field50A>();
        Tag[] tags = this.tags("50A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field50K> getField50K() {
        ArrayList<Field50K> result = new ArrayList<Field50K>();
        Tag[] tags = this.tags("50K");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field50K(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52A> getField52A() {
        ArrayList<Field52A> result = new ArrayList<Field52A>();
        Tag[] tags = this.tags("52A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52C> getField52C() {
        ArrayList<Field52C> result = new ArrayList<Field52C>();
        Tag[] tags = this.tags("52C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field52D> getField52D() {
        ArrayList<Field52D> result = new ArrayList<Field52D>();
        Tag[] tags = this.tags("52D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field52D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57A> getField57A() {
        ArrayList<Field57A> result = new ArrayList<Field57A>();
        Tag[] tags = this.tags("57A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57C> getField57C() {
        ArrayList<Field57C> result = new ArrayList<Field57C>();
        Tag[] tags = this.tags("57C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field57D> getField57D() {
        ArrayList<Field57D> result = new ArrayList<Field57D>();
        Tag[] tags = this.tags("57D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field57D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field59A> getField59A() {
        ArrayList<Field59A> result = new ArrayList<Field59A>();
        Tag[] tags = this.tags("59A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field59A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field59> getField59() {
        ArrayList<Field59> result = new ArrayList<Field59>();
        Tag[] tags = this.tags("59");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field59(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70> getField70() {
        ArrayList<Field70> result = new ArrayList<Field70>();
        Tag[] tags = this.tags("70");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field26T> getField26T() {
        ArrayList<Field26T> result = new ArrayList<Field26T>();
        Tag[] tags = this.tags("26T");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field26T(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field77B> getField77B() {
        ArrayList<Field77B> result = new ArrayList<Field77B>();
        Tag[] tags = this.tags("77B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field77B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field33B> getField33B() {
        ArrayList<Field33B> result = new ArrayList<Field33B>();
        Tag[] tags = this.tags("33B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field33B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field71A> getField71A() {
        ArrayList<Field71A> result = new ArrayList<Field71A>();
        Tag[] tags = this.tags("71A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field71A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field71F> getField71F() {
        ArrayList<Field71F> result = new ArrayList<Field71F>();
        Tag[] tags = this.tags("71F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field71F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field71G> getField71G() {
        ArrayList<Field71G> result = new ArrayList<Field71G>();
        Tag[] tags = this.tags("71G");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field71G(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field36> getField36() {
        ArrayList<Field36> result = new ArrayList<Field36>();
        Tag[] tags = this.tags("36");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field36(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return this.getSequenceA(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        if (parentSequence != null && !parentSequence.isEmpty()) {
            SwiftTagListBlock content = parentSequence.getSubBlockDelimitedWithOptionalTail(SequenceA.START, SequenceA.END, SequenceA.TAIL);
            if (log.isLoggable(Level.FINE)) {
                if (content == null) {
                    log.fine("content for sequence SequenceA: is null");
                } else {
                    log.fine("content for sequence SequenceA: " + content.tagNamesList());
                }
            }
            if (content == null) {
                return new SequenceA();
            }
            return new SequenceA(content);
        }
        return null;
    }

    public List<SequenceB> getSequenceBList() {
        return MT104.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(SequenceB.START, SequenceB.END, SequenceB.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new SequenceB(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceC getSequenceC() {
        int startIndexOfC;
        if (this.m == null || this.m.getBlock4() == null) {
            return new SequenceC(SwiftTagListBlock.EMPTY_LIST);
        }
        SwiftBlock4 b4 = this.m.getBlock4();
        int last59 = b4.indexOfAnyLast("59", "59A");
        if (last59 >= 0 && (startIndexOfC = b4.indexOfAnyFirstAfterIndex(last59, "32B")) >= 0) {
            return new SequenceC(b4.sublist(startIndexOfC, b4.size() - 1));
        }
        return new SequenceC(SwiftTagListBlock.EMPTY_LIST);
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_NAME = "32B";

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"21"};
        protected static final String[] END = new String[]{"59A", "59"};
        protected static final String[] TAIL = new String[]{"70", "26T", "77B", "33B", "71A", "71F", "71G", "36"};

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            return SequenceB.newInstance(0, 0, tags);
        }

        public static SequenceB newInstance(int start, int end, Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"30"};
        protected static final String[] TAIL = new String[]{"51A", "50C", "50L", "50A", "50K", "52A", "52C", "52D", "26T", "77B", "71A", "72"};

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            return SequenceA.newInstance(0, 0, tags);
        }

        public static SequenceA newInstance(int start, int end, Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

