/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt1xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field11S;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field79;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT192
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT192.class.getName());
    public static final String NAME = "192";

    public MT192(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT192(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT192 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT192(m);
    }

    public MT192() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT192(String sender, String receiver) {
        super(192, sender, receiver);
    }

    public MT192(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT192.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT192 object from FIN content with a Service Message. Check if the MT192 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT192 object from FIN content with message type " + param.getType());
        }
    }

    public static MT192 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT192(fin);
    }

    public MT192(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT192 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT192(stream);
    }

    public MT192(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT192 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT192(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT192 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT192 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT192 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT192 fromJson(String json) {
        return (MT192)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field21 getField21() {
        Tag t = this.tag("21");
        if (t != null) {
            return new Field21(t.getValue());
        }
        return null;
    }

    public Field11S getField11S() {
        Tag t = this.tag("11S");
        if (t != null) {
            return new Field11S(t.getValue());
        }
        return null;
    }

    public Field79 getField79() {
        Tag t = this.tag("79");
        if (t != null) {
            return new Field79(t.getValue());
        }
        return null;
    }
}

