/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt3xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field13A;
import com.prowidesoftware.swift.model.field.Field13B;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field19A;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field22H;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field70C;
import com.prowidesoftware.swift.model.field.Field92A;
import com.prowidesoftware.swift.model.field.Field94C;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field97A;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field99B;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT321
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT321.class.getName());
    public static final String NAME = "321";

    public MT321(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT321(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT321 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT321(m);
    }

    public MT321() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT321(String sender, String receiver) {
        super(321, sender, receiver);
    }

    public MT321(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT321.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT321 object from FIN content with a Service Message. Check if the MT321 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT321 object from FIN content with message type " + param.getType());
        }
    }

    public static MT321 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT321(fin);
    }

    public MT321(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT321 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT321(stream);
    }

    public MT321(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT321 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT321(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT321 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT321 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT321 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT321 fromJson(String json) {
        return (MT321)AbstractMT.fromJson(json);
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field92A getField92A() {
        Tag t = this.tag("92A");
        if (t != null) {
            return new Field92A(t.getValue());
        }
        return null;
    }

    public Field94C getField94C() {
        Tag t = this.tag("94C");
        if (t != null) {
            return new Field94C(t.getValue());
        }
        return null;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22H> getField22H() {
        ArrayList<Field22H> result = new ArrayList<Field22H>();
        Tag[] tags = this.tags("22H");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22H(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field99B> getField99B() {
        ArrayList<Field99B> result = new ArrayList<Field99B>();
        Tag[] tags = this.tags("99B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field99B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13A> getField13A() {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        Tag[] tags = this.tags("13A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13B> getField13B() {
        ArrayList<Field13B> result = new ArrayList<Field13B>();
        Tag[] tags = this.tags("13B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98A> getField98A() {
        ArrayList<Field98A> result = new ArrayList<Field98A>();
        Tag[] tags = this.tags("98A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field19A> getField19A() {
        ArrayList<Field19A> result = new ArrayList<Field19A>();
        Tag[] tags = this.tags("19A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field19A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97A> getField97A() {
        ArrayList<Field97A> result = new ArrayList<Field97A>();
        Tag[] tags = this.tags("97A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70C> getField70C() {
        ArrayList<Field70C> result = new ArrayList<Field70C>();
        Tag[] tags = this.tags("70C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70C(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("GENL").getTags());
        }
        return s;
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT321.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("LINK")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock("LINK").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceB getSequenceB() {
        return new SequenceB(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        SequenceB s = new SequenceB();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("LDDET").getTags());
        }
        return s;
    }

    public SequenceB1 getSequenceB1() {
        return new SequenceB1(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceB1 getSequenceB1(SwiftTagListBlock parentSequence) {
        SequenceB1 s = new SequenceB1();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("LDPRTY1").getTags());
        }
        return s;
    }

    public SequenceB2 getSequenceB2() {
        return new SequenceB2(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceB2 getSequenceB2(SwiftTagListBlock parentSequence) {
        SequenceB2 s = new SequenceB2();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("LDPRTY2").getTags());
        }
        return s;
    }

    public SequenceB3 getSequenceB3() {
        return new SequenceB3(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceB3 getSequenceB3(SwiftTagListBlock parentSequence) {
        SequenceB3 s = new SequenceB3();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("OTHRPRTY").getTags());
        }
        return s;
    }

    public List<SequenceC> getSequenceCList() {
        return MT321.getSequenceCList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC> getSequenceCList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SETDET")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC> result = new ArrayList<SequenceC>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC s = new SequenceC();
                s.setTags(b.getSubBlock("SETDET").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceC1> getSequenceC1List() {
        return MT321.getSequenceC1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC1> getSequenceC1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SETPRTY")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC1> result = new ArrayList<SequenceC1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC1 s = new SequenceC1();
                s.setTags(b.getSubBlock("SETPRTY").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceC1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SETPRTY";
        public static final Tag START_TAG = new Tag("16R", "SETPRTY");
        public static final Tag END_TAG = new Tag("16S", "SETPRTY");

        private SequenceC1() {
            super(new ArrayList<Tag>());
        }

        private SequenceC1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC1 newInstance(Tag ... tags) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance() {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SETDET";
        public static final Tag START_TAG = new Tag("16R", "SETDET");
        public static final Tag END_TAG = new Tag("16S", "SETDET");

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB3
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "OTHRPRTY";
        public static final Tag START_TAG = new Tag("16R", "OTHRPRTY");
        public static final Tag END_TAG = new Tag("16S", "OTHRPRTY");

        private SequenceB3() {
            super(new ArrayList<Tag>());
        }

        private SequenceB3(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB3 newInstance(Tag ... tags) {
            SequenceB3 result = new SequenceB3();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB3 newInstance() {
            SequenceB3 result = new SequenceB3();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB3 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB3 result = new SequenceB3();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB3(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LDPRTY2";
        public static final Tag START_TAG = new Tag("16R", "LDPRTY2");
        public static final Tag END_TAG = new Tag("16S", "LDPRTY2");

        private SequenceB2() {
            super(new ArrayList<Tag>());
        }

        private SequenceB2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB2 newInstance(Tag ... tags) {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2 newInstance() {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB2(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LDPRTY1";
        public static final Tag START_TAG = new Tag("16R", "LDPRTY1");
        public static final Tag END_TAG = new Tag("16S", "LDPRTY1");

        private SequenceB1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1 newInstance(Tag ... tags) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance() {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LDDET";
        public static final Tag START_TAG = new Tag("16R", "LDDET");
        public static final Tag END_TAG = new Tag("16S", "LDDET");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }
}

