/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field12A;
import com.prowidesoftware.swift.model.field.Field13A;
import com.prowidesoftware.swift.model.field.Field13B;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field17B;
import com.prowidesoftware.swift.model.field.Field19A;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field20U;
import com.prowidesoftware.swift.model.field.Field22F;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field24B;
import com.prowidesoftware.swift.model.field.Field25D;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field36B;
import com.prowidesoftware.swift.model.field.Field70D;
import com.prowidesoftware.swift.model.field.Field90A;
import com.prowidesoftware.swift.model.field.Field90B;
import com.prowidesoftware.swift.model.field.Field95L;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field97A;
import com.prowidesoftware.swift.model.field.Field97B;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field98C;
import com.prowidesoftware.swift.model.field.Field98E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT530
extends AbstractMT
implements Serializable {
    public static final int SRU = 2021;
    private static final long serialVersionUID = 1L;
    private static final transient Logger log = Logger.getLogger(MT530.class.getName());
    public static final String NAME = "530";

    public MT530(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT530(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT530 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT530(m);
    }

    public MT530() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT530(String sender, String receiver) {
        super(530, sender, receiver);
    }

    public MT530(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT530.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT530 object from FIN content with a Service Message. Check if the MT530 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)this.getMessageType())) {
            log.warning("Creating an MT530 object from FIN content with message type " + param.getType());
        }
    }

    public static MT530 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT530(fin);
    }

    public MT530(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT530 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT530(stream);
    }

    public MT530(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT530 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT530(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT530 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT530 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT530 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT530 fromJson(String json) {
        return (MT530)AbstractMT.fromJson(json);
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field98E getField98E() {
        Tag t = this.tag("98E");
        if (t != null) {
            return new Field98E(t.getValue());
        }
        return null;
    }

    public Field12A getField12A() {
        Tag t = this.tag("12A");
        if (t != null) {
            return new Field12A(t.getValue());
        }
        return null;
    }

    public Field35B getField35B() {
        Tag t = this.tag("35B");
        if (t != null) {
            return new Field35B(t.getValue());
        }
        return null;
    }

    public Field36B getField36B() {
        Tag t = this.tag("36B");
        if (t != null) {
            return new Field36B(t.getValue());
        }
        return null;
    }

    public Field90A getField90A() {
        Tag t = this.tag("90A");
        if (t != null) {
            return new Field90A(t.getValue());
        }
        return null;
    }

    public Field90B getField90B() {
        Tag t = this.tag("90B");
        if (t != null) {
            return new Field90B(t.getValue());
        }
        return null;
    }

    public Field19A getField19A() {
        Tag t = this.tag("19A");
        if (t != null) {
            return new Field19A(t.getValue());
        }
        return null;
    }

    public Field17B getField17B() {
        Tag t = this.tag("17B");
        if (t != null) {
            return new Field17B(t.getValue());
        }
        return null;
    }

    public Field25D getField25D() {
        Tag t = this.tag("25D");
        if (t != null) {
            return new Field25D(t.getValue());
        }
        return null;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95L> getField95L() {
        ArrayList<Field95L> result = new ArrayList<Field95L>();
        Tag[] tags = this.tags("95L");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95L(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field20U> getField20U() {
        ArrayList<Field20U> result = new ArrayList<Field20U>();
        Tag[] tags = this.tags("20U");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20U(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22F> getField22F() {
        ArrayList<Field22F> result = new ArrayList<Field22F>();
        Tag[] tags = this.tags("22F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13A> getField13A() {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        Tag[] tags = this.tags("13A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13B> getField13B() {
        ArrayList<Field13B> result = new ArrayList<Field13B>();
        Tag[] tags = this.tags("13B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97A> getField97A() {
        ArrayList<Field97A> result = new ArrayList<Field97A>();
        Tag[] tags = this.tags("97A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97B> getField97B() {
        ArrayList<Field97B> result = new ArrayList<Field97B>();
        Tag[] tags = this.tags("97B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98A> getField98A() {
        ArrayList<Field98A> result = new ArrayList<Field98A>();
        Tag[] tags = this.tags("98A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98C> getField98C() {
        ArrayList<Field98C> result = new ArrayList<Field98C>();
        Tag[] tags = this.tags("98C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field24B> getField24B() {
        ArrayList<Field24B> result = new ArrayList<Field24B>();
        Tag[] tags = this.tags("24B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field24B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70D> getField70D() {
        ArrayList<Field70D> result = new ArrayList<Field70D>();
        Tag[] tags = this.tags("70D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70D(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("GENL").getTags());
        }
        return s;
    }

    public List<SequenceB> getSequenceBList() {
        return MT530.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("REQD")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB s = new SequenceB();
                s.setTags(b.getSubBlock("REQD").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<SequenceB1> getSequenceB1List() {
        return MT530.getSequenceB1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceB1> getSequenceB1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("LINK")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB1> result = new ArrayList<SequenceB1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB1 s = new SequenceB1();
                s.setTags(b.getSubBlock("LINK").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceC getSequenceC() {
        return new SequenceC(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceC getSequenceC(SwiftTagListBlock parentSequence) {
        SequenceC s = new SequenceC();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("ADDINFO").getTags());
        }
        return s;
    }

    public SequenceC1 getSequenceC1() {
        return new SequenceC1(super.getSwiftMessageNotNullOrException());
    }

    public static SequenceC1 getSequenceC1(SwiftTagListBlock parentSequence) {
        SequenceC1 s = new SequenceC1();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("STAT").getTags());
        }
        return s;
    }

    public List<SequenceC1a> getSequenceC1aList() {
        return MT530.getSequenceC1aList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<SequenceC1a> getSequenceC1aList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("REAS")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceC1a> result = new ArrayList<SequenceC1a>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceC1a s = new SequenceC1a();
                s.setTags(b.getSubBlock("REAS").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class SequenceC1a
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "REAS";
        public static final Tag START_TAG = new Tag("16R", "REAS");
        public static final Tag END_TAG = new Tag("16S", "REAS");

        private SequenceC1a() {
            super(new ArrayList<Tag>());
        }

        private SequenceC1a(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC1a newInstance(Tag ... tags) {
            SequenceC1a result = new SequenceC1a();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1a newInstance() {
            SequenceC1a result = new SequenceC1a();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1a newInstance(SwiftTagListBlock ... sequences) {
            SequenceC1a result = new SequenceC1a();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC1a(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "STAT";
        public static final Tag START_TAG = new Tag("16R", "STAT");
        public static final Tag END_TAG = new Tag("16S", "STAT");

        private SequenceC1() {
            super(new ArrayList<Tag>());
        }

        private SequenceC1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC1 newInstance(Tag ... tags) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance() {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceC1 result = new SequenceC1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "ADDINFO";
        public static final Tag START_TAG = new Tag("16R", "ADDINFO");
        public static final Tag END_TAG = new Tag("16S", "ADDINFO");

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceB1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1 newInstance(Tag ... tags) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance() {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "REQD";
        public static final Tag START_TAG = new Tag("16R", "REQD");
        public static final Tag END_TAG = new Tag("16S", "REQD");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }
}

