/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field11A;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field22F;
import com.prowidesoftware.swift.model.field.Field22H;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field70E;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field95S;
import com.prowidesoftware.swift.model.field.Field97A;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.model.mt.SequenceUtils;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT671
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT671.class.getName());
    public static final String NAME = "671";

    public MT671(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT671(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT671 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT671(m);
    }

    public MT671() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT671(String sender, String receiver) {
        super(671, sender, receiver);
    }

    public MT671(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT671.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT671 object from FIN content with a Service Message. Check if the MT671 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT671 object from FIN content with message type " + param.getType());
        }
    }

    public static MT671 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT671(fin);
    }

    public MT671(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT671 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT671(stream);
    }

    public MT671(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT671 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT671(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT671 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT671 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT671 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT671 fromJson(String json) {
        return (MT671)AbstractMT.fromJson(json);
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22H> getField22H() {
        ArrayList<Field22H> result = new ArrayList<Field22H>();
        Tag[] tags = this.tags("22H");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22H(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field11A> getField11A() {
        ArrayList<Field11A> result = new ArrayList<Field11A>();
        Tag[] tags = this.tags("11A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field11A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98A> getField98A() {
        ArrayList<Field98A> result = new ArrayList<Field98A>();
        Tag[] tags = this.tags("98A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22F> getField22F() {
        ArrayList<Field22F> result = new ArrayList<Field22F>();
        Tag[] tags = this.tags("22F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95S> getField95S() {
        ArrayList<Field95S> result = new ArrayList<Field95S>();
        Tag[] tags = this.tags("95S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field97A> getField97A() {
        ArrayList<Field97A> result = new ArrayList<Field97A>();
        Tag[] tags = this.tags("97A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field97A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70E> getField70E() {
        ArrayList<Field70E> result = new ArrayList<Field70E>();
        Tag[] tags = this.tags("70E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70E(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public SequenceA getSequenceGENL() {
        return this.getSequenceA();
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("GENL").getTags());
        }
        return s;
    }

    public static SequenceA getSequenceGENL(SwiftTagListBlock parentSequence) {
        return MT671.getSequenceA(parentSequence);
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT671.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceA1> getSequenceLINKList() {
        return this.getSequenceA1List();
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("LINK")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock("LINK").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceA1> getSequenceLINKList(SwiftTagListBlock parentSequence) {
        return MT671.getSequenceA1List(parentSequence);
    }

    public List<SequenceB> getSequenceBList() {
        return MT671.getSequenceBList(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB> getSequenceSSIDETList() {
        return this.getSequenceBList();
    }

    public static List<SequenceB> getSequenceBList(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("SSIDET")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB> result = new ArrayList<SequenceB>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB s = new SequenceB();
                s.setTags(b.getSubBlock("SSIDET").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB> getSequenceSSIDETList(SwiftTagListBlock parentSequence) {
        return MT671.getSequenceBList(parentSequence);
    }

    public List<SequenceB1> getSequenceB1List() {
        return MT671.getSequenceB1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceB1> getSequenceCSHPRTYList() {
        return this.getSequenceB1List();
    }

    public static List<SequenceB1> getSequenceB1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("CSHPRTY")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB1> result = new ArrayList<SequenceB1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB1 s = new SequenceB1();
                s.setTags(b.getSubBlock("CSHPRTY").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceB1> getSequenceCSHPRTYList(SwiftTagListBlock parentSequence) {
        return MT671.getSequenceB1List(parentSequence);
    }

    public List<SequenceB2> getSequenceB2List() {
        if (this.getSwiftMessage() == null) {
            return null;
        }
        return SequenceUtils.resolveMT671GetSequenceB2List_sru2022(this);
    }

    public static List<SequenceB2> getSequenceB2List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("OTHRDET")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceB2> result = new ArrayList<SequenceB2>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceB2 s = new SequenceB2();
                s.setTags(b.getSubBlock("OTHRDET").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public SequenceC getSequenceC() {
        if (this.getSwiftMessage() == null) {
            return null;
        }
        return SequenceUtils.resolveMT671GetSequenceC_sru2022(this);
    }

    public SequenceC getSequenceOTHRDET() {
        return this.getSequenceC();
    }

    public static SequenceC getSequenceC(SwiftTagListBlock parentSequence) {
        SequenceC s = new SequenceC();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("OTHRDET").getTags());
        }
        return s;
    }

    public static SequenceC getSequenceOTHRDET(SwiftTagListBlock parentSequence) {
        return MT671.getSequenceC(parentSequence);
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "OTHRDET";
        public static final Tag START_TAG = new Tag("16R", "OTHRDET");
        public static final Tag END_TAG = new Tag("16S", "OTHRDET");

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "OTHRDET";
        public static final Tag START_TAG = new Tag("16R", "OTHRDET");
        public static final Tag END_TAG = new Tag("16S", "OTHRDET");

        private SequenceB2() {
            super(new ArrayList<Tag>());
        }

        private SequenceB2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB2 newInstance(Tag ... tags) {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2 newInstance() {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB2 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB2 result = new SequenceB2();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB2(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "CSHPRTY";
        public static final Tag START_TAG = new Tag("16R", "CSHPRTY");
        public static final Tag END_TAG = new Tag("16S", "CSHPRTY");

        private SequenceB1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1 newInstance(Tag ... tags) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance() {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "SSIDET";
        public static final Tag START_TAG = new Tag("16R", "SSIDET");
        public static final Tag END_TAG = new Tag("16S", "SSIDET");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }
}

