/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field90A
extends Field
implements Serializable,
AmountContainer,
GenericField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "90A";
    public static final String F_90A = "90A";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S/[S]N";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSN";
    @Deprecated
    public static final String TYPES_PATTERN = "SSSI";
    public static final Integer QUALIFIER = 1;
    public static final Integer PERCENTAGE_TYPE_CODE = 2;
    public static final Integer SIGN = 3;
    public static final Integer PRICE = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field90A() {
        super(4);
    }

    public Field90A(String value) {
        super(value);
    }

    public Field90A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"90A")) {
            throw new IllegalArgumentException("cannot create field 90A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field90A newInstance(Field90A source) {
        Field90A cp = new Field90A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("90A", value);
    }

    public static Tag emptyTag() {
        return new Tag("90A", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        this.setComponent2(SwiftParseUtils.getTokenFirst(toparse, "/"));
        String toparse2 = SwiftParseUtils.getTokenSecondLast(toparse, "/");
        this.setComponent3(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse2));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 90A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent4AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//4!c/[<N>]<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Percentage Type Code");
        result.add("Sign");
        result.add("Price");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "percentageTypeCode");
        result.put(3, "sign");
        result.put(4, "price");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("percentagetypecode", 2);
        this.labelMap.put("sign", 3);
        this.labelMap.put("price", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPercentageTypeCode() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getSign() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BigDecimal getComponent4AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(4));
    }

    @Deprecated
    public Number getComponent4AsNumber() {
        return this.getComponent4AsBigDecimal();
    }

    public String getPrice() {
        return this.getComponent4();
    }

    public BigDecimal getPriceAsBigDecimal() {
        return this.getComponent4AsBigDecimal();
    }

    @Deprecated
    public Number getPriceAsNumber() {
        return this.getComponent4AsNumber();
    }

    public Field90A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field90A setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field90A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field90A setPercentageTypeCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field90A setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field90A setSign(String component3) {
        return this.setComponent3(component3);
    }

    public Field90A setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field90A setComponent4(BigDecimal component4) {
        this.setComponent(4, SwiftFormatUtils.getBigDecimal(component4));
        return this;
    }

    public Field90A setComponent4(Number component4) {
        if (component4 instanceof BigDecimal) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal((BigDecimal)component4));
        } else if (component4 instanceof BigInteger) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component4)));
        } else if (component4 instanceof Long || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.longValue())));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.doubleValue())));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field90A setPrice(String component4) {
        return this.setComponent4(component4);
    }

    public Field90A setPrice(BigDecimal component4) {
        return this.setComponent4(component4);
    }

    public Field90A setPrice(Number component4) {
        return this.setComponent4(component4);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "90A";
    }

    public static Field90A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("90A");
        if (t == null) {
            return null;
        }
        return new Field90A(t);
    }

    public static Field90A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field90A.get(msg.getBlock4());
    }

    public static List<Field90A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field90A.getAll(msg.getBlock4());
    }

    public static List<Field90A> getAll(SwiftTagListBlock block) {
        ArrayList<Field90A> result = new ArrayList<Field90A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("90A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field90A(f));
            }
        }
        return result;
    }

    public static Field90A fromJson(String json) {
        Field90A field = new Field90A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("percentageTypeCode") != null) {
            field.setComponent2(jsonObject.get("percentageTypeCode").getAsString());
        }
        if (jsonObject.get("sign") != null) {
            field.setComponent3(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("price") != null) {
            field.setComponent4(jsonObject.get("price").getAsString());
        }
        return field;
    }
}

