/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field202;
import com.prowidesoftware.swift.model.field.Field203;
import com.prowidesoftware.swift.model.field.Field311;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT092
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT092.class.getName());
    public static final String NAME = "092";

    public MT092(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT092(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT092 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT092(m);
    }

    public MT092() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT092(String sender, String receiver) {
        super(92, sender, receiver);
    }

    public MT092(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT092.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT092 object from FIN content with a Service Message. Check if the MT092 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT092 object from FIN content with message type " + param.getType());
        }
    }

    public static MT092 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT092(fin);
    }

    public MT092(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT092 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT092(stream);
    }

    public MT092(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT092 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT092(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT092 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT092 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT092 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT092 fromJson(String json) {
        return (MT092)AbstractMT.fromJson(json);
    }

    public Field202 getField202() {
        Tag t = this.tag("202");
        if (t != null) {
            return new Field202(t.getValue());
        }
        return null;
    }

    public Field203 getField203() {
        Tag t = this.tag("203");
        if (t != null) {
            return new Field203(t.getValue());
        }
        return null;
    }

    public Field311 getField311() {
        Tag t = this.tag("311");
        if (t != null) {
            return new Field311(t.getValue());
        }
        return null;
    }
}

