/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt0xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field129;
import com.prowidesoftware.swift.model.field.Field130;
import com.prowidesoftware.swift.model.field.Field132;
import com.prowidesoftware.swift.model.field.Field133;
import com.prowidesoftware.swift.model.field.Field134;
import com.prowidesoftware.swift.model.field.Field135;
import com.prowidesoftware.swift.model.field.Field136;
import com.prowidesoftware.swift.model.field.Field137;
import com.prowidesoftware.swift.model.field.Field312;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT094
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT094.class.getName());
    public static final String NAME = "094";

    public MT094(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT094(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT094 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT094(m);
    }

    public MT094() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT094(String sender, String receiver) {
        super(94, sender, receiver);
    }

    public MT094(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT094.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT094 object from FIN content with a Service Message. Check if the MT094 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT094 object from FIN content with message type " + param.getType());
        }
    }

    public static MT094 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT094(fin);
    }

    public MT094(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT094 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT094(stream);
    }

    public MT094(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT094 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT094(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT094 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT094 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT094 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT094 fromJson(String json) {
        return (MT094)AbstractMT.fromJson(json);
    }

    public Field135 getField135() {
        Tag t = this.tag("135");
        if (t != null) {
            return new Field135(t.getValue());
        }
        return null;
    }

    public Field136 getField136() {
        Tag t = this.tag("136");
        if (t != null) {
            return new Field136(t.getValue());
        }
        return null;
    }

    public Field137 getField137() {
        Tag t = this.tag("137");
        if (t != null) {
            return new Field137(t.getValue());
        }
        return null;
    }

    public Field129 getField129() {
        Tag t = this.tag("129");
        if (t != null) {
            return new Field129(t.getValue());
        }
        return null;
    }

    public Field130 getField130() {
        Tag t = this.tag("130");
        if (t != null) {
            return new Field130(t.getValue());
        }
        return null;
    }

    public Field134 getField134() {
        Tag t = this.tag("134");
        if (t != null) {
            return new Field134(t.getValue());
        }
        return null;
    }

    public Field312 getField312() {
        Tag t = this.tag("312");
        if (t != null) {
            return new Field312(t.getValue());
        }
        return null;
    }

    public List<Field132> getField132() {
        ArrayList<Field132> result = new ArrayList<Field132>();
        Tag[] tags = this.tags("132");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field132(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field133> getField133() {
        ArrayList<Field133> result = new ArrayList<Field133>();
        Tag[] tags = this.tags("133");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field133(tag.getValue()));
            }
        }
        return result;
    }
}

