/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field50A
extends Field
implements Serializable,
BICContainer,
MultiLineField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "50A";
    public static final String F_50A = "50A";
    @Deprecated
    public static final String PARSER_PATTERN = "[/S$]S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SB";
    @Deprecated
    public static final String TYPES_PATTERN = "SB";
    public static final Integer ACCOUNT = 1;
    public static final Integer IDENTIFIER_CODE = 2;
    @Deprecated
    public static final Integer BIC = 2;

    public Field50A() {
        super(2);
    }

    public Field50A(String value) {
        super(value);
    }

    public Field50A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"50A")) {
            throw new IllegalArgumentException("cannot create field 50A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field50A newInstance(Field50A source) {
        Field50A cp = new Field50A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("50A", value);
    }

    public static Tag emptyTag() {
        return new Tag("50A", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            if (lines.get(0).startsWith("/")) {
                this.setComponent1(StringUtils.substring((String)lines.get(0), (int)1));
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 1, lines);
            } else {
                SwiftParseUtils.setComponentsFromLines(this, 2, null, 0, lines);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        this.appendInLines(result, this.getComponent2());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 50A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SB";
    }

    @Override
    public String typesPattern() {
        return "SB";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "[/34x$]<BIC>";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Account");
        result.add("Identifier Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "account");
        result.put(2, "identifierCode");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("account", 1);
        this.labelMap.put("identifiercode", 2);
        this.labelMap.put("bic", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getAccount() {
        String account = this.getComponent(1);
        if (account != null) {
            for (int i = 0; i < account.length(); ++i) {
                if (account.charAt(i) == '/') continue;
                return account.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BIC getComponent2AsBIC() {
        return SwiftFormatUtils.getBIC(this.getComponent(2));
    }

    public String getIdentifierCode() {
        return this.getComponent2();
    }

    @Deprecated
    public String getBIC() {
        return this.getIdentifierCode();
    }

    public BIC getIdentifierCodeAsBIC() {
        return this.getComponent2AsBIC();
    }

    @Deprecated
    public BIC getBICAsBIC() {
        return this.getIdentifierCodeAsBIC();
    }

    public Field50A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field50A setAccount(String component1) {
        return this.setComponent1(component1);
    }

    public Field50A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field50A setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public Field50A setIdentifierCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field50A setIdentifierCode(BIC component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field50A setBIC(String component2) {
        return this.setIdentifierCode(component2);
    }

    @Deprecated
    public Field50A setBIC(BIC component2) {
        return this.setIdentifierCode(component2);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getName() {
        return "50A";
    }

    public static Field50A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("50A");
        if (t == null) {
            return null;
        }
        return new Field50A(t);
    }

    public static Field50A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field50A.get(msg.getBlock4());
    }

    public static List<Field50A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field50A.getAll(msg.getBlock4());
    }

    public static List<Field50A> getAll(SwiftTagListBlock block) {
        ArrayList<Field50A> result = new ArrayList<Field50A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("50A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field50A(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field50A cp = Field50A.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field50A cp = Field50A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field50A cp = Field50A.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field50A fromJson(String json) {
        Field50A field = new Field50A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("account") != null) {
            field.setComponent1(jsonObject.get("account").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent2(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent2(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

