/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.prowidesoftware.swift.model.mt.MTVariant;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MtId {
    private static final Pattern TYPE_PATTERN = Pattern.compile("\\d{3}");
    private String businessProcess = "fin";
    private String messageType;
    private String variant;

    public MtId() {
    }

    public MtId(String identifier) {
        this();
        if (identifier != null) {
            Matcher matcher = TYPE_PATTERN.matcher(identifier);
            if (matcher.find()) {
                this.messageType = matcher.group(0);
            }
            if (StringUtils.isNotBlank((CharSequence)this.messageType)) {
                MTVariant.extract(identifier).ifPresent(variant -> {
                    this.variant = variant.name();
                });
            } else {
                this.messageType = identifier;
            }
        }
    }

    public MtId(String messageType, String variant) {
        this.messageType = StringUtils.startsWith((CharSequence)messageType, (CharSequence)"fin.") ? StringUtils.substringAfter((String)messageType, (String)"fin.") : messageType;
        this.variant = variant;
    }

    public MtId(String messageType, MTVariant variant) {
        this(messageType, variant != null ? variant.name() : null);
    }

    public static MtId parse(String identifier) {
        return new MtId(identifier);
    }

    public String getBusinessProcess() {
        return this.businessProcess;
    }

    public MtId setBusinessProcess(String businessProcess) {
        this.businessProcess = businessProcess;
        return this;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public MtId setMessageType(String messageType) {
        this.messageType = messageType;
        return this;
    }

    public String getVariant() {
        return this.variant;
    }

    public MtId setVariant(String variant) {
        this.variant = variant;
        return this;
    }

    public MtId setVariant(MTVariant variant) {
        this.variant = variant.name();
        return this;
    }

    public String toString() {
        return this.id();
    }

    public String id() {
        StringBuilder sb = new StringBuilder();
        if (this.businessProcess == null) {
            return null;
        }
        sb.append(this.businessProcess);
        if (this.messageType == null) {
            return null;
        }
        sb.append(".").append(this.messageType);
        if (this.variant != null) {
            sb.append(".").append(this.variant);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MtId mtId = (MtId)o;
        return Objects.equals(this.businessProcess, mtId.businessProcess) && Objects.equals(this.messageType, mtId.messageType) && Objects.equals(this.variant, mtId.variant);
    }

    public int hashCode() {
        return Objects.hash(this.businessProcess, this.messageType, this.variant);
    }

    public String category() {
        char cat;
        if (this.messageType != null && this.messageType.length() > 0 && Character.isDigit(cat = this.messageType.charAt(0))) {
            return String.valueOf(cat);
        }
        return "";
    }

    public String namespaceURI() {
        return "urn:swift:xsd:" + this.id() + "." + 2022;
    }
}

