/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.prowidesoftware.deprecation.DeprecationUtils;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang3.Validate;

public class SwiftBlockUser
extends SwiftTagListBlock
implements Serializable {
    private static final long serialVersionUID = -6506492203870561424L;
    private static final String MESSAGE_VALIDATOR = "parameter 'blockNumber' cannot be null";
    private static final transient Logger log = Logger.getLogger(DeprecationUtils.class.getName());
    protected Integer sortKey;
    protected String blockName;

    public SwiftBlockUser() {
        this.setBlockName("0");
    }

    public SwiftBlockUser(Integer blockNumber) {
        Objects.requireNonNull(blockNumber, MESSAGE_VALIDATOR);
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)"'blockNumber' is not a valid User Defined Block number", (Object[])new Object[0]);
        this.setBlockNumber(blockNumber);
    }

    public SwiftBlockUser(Integer blockNumber, List<Tag> tags) {
        Objects.requireNonNull(blockNumber, MESSAGE_VALIDATOR);
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)"'blockNumber' is not a valid User Defined Block number", (Object[])new Object[0]);
        this.setBlockNumber(blockNumber);
        this.addTags(tags);
    }

    public SwiftBlockUser(String blockName) {
        Objects.requireNonNull(blockName, "parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)"'blockName' is not a valid User Defined Block name", (Object[])new Object[0]);
        this.setBlockName(blockName);
    }

    public SwiftBlockUser(String blockName, List<Tag> tags) {
        Objects.requireNonNull(blockName, "parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)"'blockName' is not a valid User Defined Block name", (Object[])new Object[0]);
        this.setBlockName(blockName);
        this.addTags(tags);
    }

    public static Boolean isValidName(String blockName, Integer blockNumber) {
        return SwiftBlockUser.isValidName(blockName) != false && SwiftBlockUser.isValidName(blockNumber) != false;
    }

    public static Boolean isValidName(String blockName) {
        if (blockName == null) {
            return Boolean.FALSE;
        }
        try {
            Integer num = Integer.decode(blockName);
            if (!SwiftBlockUser.isValidName(num).booleanValue()) {
                return Boolean.FALSE;
            }
        }
        catch (NumberFormatException num) {
            // empty catch block
        }
        if (blockName.length() != 1) {
            return Boolean.FALSE;
        }
        char c = Character.toLowerCase(blockName.charAt(0));
        if (!('0' <= c && c <= '9' || 'a' <= c && c <= 'z')) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static Boolean isValidName(Integer blockNumber) {
        if (blockNumber == null) {
            return Boolean.FALSE;
        }
        if (blockNumber != -1 && 1 <= blockNumber && blockNumber <= 5) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static SwiftBlockUser fromJson(String json) {
        Gson gson = new GsonBuilder().create();
        return (SwiftBlockUser)gson.fromJson(json, SwiftBlockUser.class);
    }

    @Override
    public Integer getNumber() {
        int blockNumber = -1;
        try {
            blockNumber = Integer.decode(this.blockName);
        }
        catch (NumberFormatException ignored) {
            log.log(Level.FINE, "Could not get int from " + this.blockName);
        }
        return blockNumber;
    }

    @Override
    public String getName() {
        return this.getBlockName();
    }

    public String getBlockName() {
        return this.blockName;
    }

    @Override
    protected void setBlockName(String blockName) {
        Objects.requireNonNull(blockName, "parameter 'blockName' cannot be null");
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockName), (String)("'" + blockName + "' is not a valid User Defined Block name"), (Object[])new Object[0]);
        this.blockName = blockName;
    }

    @Override
    protected void setBlockNumber(Integer blockNumber) {
        Objects.requireNonNull(blockNumber, MESSAGE_VALIDATOR);
        Validate.isTrue((boolean)SwiftBlockUser.isValidName(blockNumber), (String)("'" + blockNumber + "' is not a valid User Defined Block number"), (Object[])new Object[0]);
        this.blockName = blockNumber != null ? blockNumber.toString() : null;
    }

    protected Boolean isValidName() {
        return SwiftBlockUser.isValidName(this.getName(), this.getNumber());
    }

    public Integer getSortKey() {
        return this.sortKey;
    }

    public void setSortKey(Integer sortKey) {
        this.sortKey = sortKey;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SwiftBlockUser tags = (SwiftBlockUser)o;
        return Objects.equals(this.sortKey, tags.sortKey) && Objects.equals(this.blockName, tags.blockName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.sortKey, this.blockName);
    }
}

