/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field33G
extends Field
implements Serializable,
MonetaryAmountContainer {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "33G";
    public static final String F_33G = "33G";
    @Deprecated
    public static final String PARSER_PATTERN = "SNS";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "CNS";
    @Deprecated
    public static final String TYPES_PATTERN = "CIS";
    public static final Integer CURRENCY = 1;
    public static final Integer PRICE = 2;
    @Deprecated
    public static final Integer AMOUNT = 2;
    public static final Integer CODE = 3;

    public Field33G() {
        super(3);
    }

    public Field33G(String value) {
        super(value);
    }

    public Field33G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"33G")) {
            throw new IllegalArgumentException("cannot create field 33G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field33G newInstance(Field33G source) {
        Field33G cp = new Field33G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("33G", value);
    }

    public static Tag emptyTag() {
        return new Tag("33G", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = this.getComponent1() == null ? value : StringUtils.substringAfter((String)value, (String)this.getComponent1());
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        this.setComponent3(SwiftParseUtils.getAlphaSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 33G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent2AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "<CUR><AMOUNT>15[5!c]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("Price");
        result.add("Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "currency");
        result.put(2, "price");
        result.put(3, "code");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent1();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent1AsCurrency();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public BigDecimal getComponent2AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        return this.getComponent2AsBigDecimal();
    }

    public String getPrice() {
        return this.getComponent2();
    }

    @Deprecated
    public String getAmount() {
        return this.getPrice();
    }

    public BigDecimal getPriceAsBigDecimal() {
        return this.getComponent2AsBigDecimal();
    }

    @Deprecated
    public Number getPriceAsNumber() {
        return this.getComponent2AsNumber();
    }

    @Deprecated
    public BigDecimal getAmountAsBigDecimal() {
        return this.getPriceAsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getPriceAsNumber();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getCode() {
        return this.getComponent3();
    }

    public Field33G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field33G setComponent1(Currency component1) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(component1));
        return this;
    }

    public Field33G setCurrency(String component1) {
        return this.setComponent1(component1);
    }

    public Field33G setCurrency(Currency component1) {
        return this.setComponent1(component1);
    }

    public Field33G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field33G setComponent2(BigDecimal component2) {
        this.setComponent(2, SwiftFormatUtils.getBigDecimal(component2));
        return this;
    }

    public Field33G setComponent2(Number component2) {
        if (component2 instanceof BigDecimal) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal((BigDecimal)component2));
        } else if (component2 instanceof BigInteger) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component2)));
        } else if (component2 instanceof Long || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.longValue())));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component2.doubleValue())));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field33G setPrice(String component2) {
        return this.setComponent2(component2);
    }

    public Field33G setPrice(BigDecimal component2) {
        return this.setComponent2(component2);
    }

    public Field33G setPrice(Number component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field33G setAmount(String component2) {
        return this.setPrice(component2);
    }

    @Deprecated
    public Field33G setAmount(BigDecimal component2) {
        return this.setPrice(component2);
    }

    @Deprecated
    public Field33G setAmount(Number component2) {
        return this.setPrice(component2);
    }

    public Field33G setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field33G setCode(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "33G";
    }

    public static Field33G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("33G");
        if (t == null) {
            return null;
        }
        return new Field33G(t);
    }

    public static Field33G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field33G.get(msg.getBlock4());
    }

    public static List<Field33G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field33G.getAll(msg.getBlock4());
    }

    public static List<Field33G> getAll(SwiftTagListBlock block) {
        ArrayList<Field33G> result = new ArrayList<Field33G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("33G");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field33G(f));
            }
        }
        return result;
    }

    public static Field33G fromJson(String json) {
        Field33G field = new Field33G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent2(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("price") != null) {
            field.setComponent2(jsonObject.get("price").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent3(jsonObject.get("code").getAsString());
        }
        return field;
    }
}

