/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt8xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field16A;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field26A;
import com.prowidesoftware.swift.model.field.Field28;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field33B;
import com.prowidesoftware.swift.model.field.Field34B;
import com.prowidesoftware.swift.model.field.Field51A;
import com.prowidesoftware.swift.model.field.Field51C;
import com.prowidesoftware.swift.model.field.Field73;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT801
extends AbstractMT
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT801.class.getName());
    public static final String NAME = "801";

    public MT801(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT801(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT801 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT801(m);
    }

    public MT801() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT801(String sender, String receiver) {
        super(801, sender, receiver);
    }

    public MT801(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT801.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT801 object from FIN content with a Service Message. Check if the MT801 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT801 object from FIN content with message type " + param.getType());
        }
    }

    public static MT801 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT801(fin);
    }

    public MT801(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT801 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT801(stream);
    }

    public MT801(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT801 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT801(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT801 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT801 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT801 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT801 fromJson(String json) {
        return (MT801)AbstractMT.fromJson(json);
    }

    public Field20 getField20() {
        Tag t = this.tag("20");
        if (t != null) {
            return new Field20(t.getValue());
        }
        return null;
    }

    public Field28 getField28() {
        Tag t = this.tag("28");
        if (t != null) {
            return new Field28(t.getValue());
        }
        return null;
    }

    public List<Field51A> getField51A() {
        ArrayList<Field51A> result = new ArrayList<Field51A>();
        Tag[] tags = this.tags("51A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field51A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field51C> getField51C() {
        ArrayList<Field51C> result = new ArrayList<Field51C>();
        Tag[] tags = this.tags("51C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field51C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field23> getField23() {
        ArrayList<Field23> result = new ArrayList<Field23>();
        Tag[] tags = this.tags("23");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field23(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field30> getField30() {
        ArrayList<Field30> result = new ArrayList<Field30>();
        Tag[] tags = this.tags("30");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field30(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field26A> getField26A() {
        ArrayList<Field26A> result = new ArrayList<Field26A>();
        Tag[] tags = this.tags("26A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field26A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field33B> getField33B() {
        ArrayList<Field33B> result = new ArrayList<Field33B>();
        Tag[] tags = this.tags("33B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field33B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field73> getField73() {
        ArrayList<Field73> result = new ArrayList<Field73>();
        Tag[] tags = this.tags("73");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field73(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field34B> getField34B() {
        ArrayList<Field34B> result = new ArrayList<Field34B>();
        Tag[] tags = this.tags("34B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field34B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16A> getField16A() {
        ArrayList<Field16A> result = new ArrayList<Field16A>();
        Tag[] tags = this.tags("16A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Loop1> getLoop1List() {
        return MT801.getLoop1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<Loop1> getLoop1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(Loop1.START, Loop1.END, Loop1.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<Loop1> result = new ArrayList<Loop1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new Loop1(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public List<Loop2> getLoop2List() {
        return MT801.getLoop2List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<Loop2> getLoop2List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(Loop2.START, Loop2.END, Loop2.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<Loop2> result = new ArrayList<Loop2>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new Loop2(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class Loop2
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"23"};
        protected static final String[] END = new String[]{"33B"};
        protected static final String[] TAIL = new String[]{"73"};

        private Loop2() {
            super(new ArrayList<Tag>());
        }

        private Loop2(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static Loop2 newInstance(Tag ... tags) {
            return Loop2.newInstance(0, 0, tags);
        }

        public static Loop2 newInstance(int start, int end, Tag ... tags) {
            Loop2 result = new Loop2();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }

    public static class Loop1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"51A", "51C"};
        protected static final String[] END = new String[]{"16A"};
        protected static final String[] TAIL = new String[0];

        private Loop1() {
            super(new ArrayList<Tag>());
        }

        private Loop1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static Loop1 newInstance(Tag ... tags) {
            return Loop1.newInstance(0, 0, tags);
        }

        public static Loop1 newInstance(int start, int end, Tag ... tags) {
            Loop1 result = new Loop1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

