/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field28D
extends Field
implements Serializable {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "28D";
    public static final String F_28D = "28D";
    @Deprecated
    public static final String PARSER_PATTERN = "S/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "NN";
    @Deprecated
    public static final String TYPES_PATTERN = "NN";
    public static final Integer MESSAGE_INDEX = 1;
    @Deprecated
    public static final Integer STATEMENT_NUMBER = 1;
    public static final Integer TOTAL = 2;
    @Deprecated
    public static final Integer SEQUENCE_NUMBER = 2;

    public Field28D() {
        super(2);
    }

    public Field28D(String value) {
        super(value);
    }

    public Field28D(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"28D")) {
            throw new IllegalArgumentException("cannot create field 28D from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field28D newInstance(Field28D source) {
        Field28D cp = new Field28D();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("28D", value);
    }

    public static Tag emptyTag() {
        return new Tag("28D", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 28D");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "NN";
    }

    @Override
    public String typesPattern() {
        return "NN";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "5n/5n";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Message Index");
        result.add("Total");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "messageIndex");
        result.put(2, "total");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    @Deprecated
    public Number getComponent1AsNumber() {
        Long l = this.getComponent1AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getMessageIndex() {
        return this.getComponent1();
    }

    @Deprecated
    public String getStatementNumber() {
        return this.getMessageIndex();
    }

    public Long getMessageIndexAsLong() {
        return this.getComponent1AsLong();
    }

    @Deprecated
    public Number getMessageIndexAsNumber() {
        return this.getComponent1AsNumber();
    }

    @Deprecated
    public Long getStatementNumberAsLong() {
        return this.getMessageIndexAsLong();
    }

    @Deprecated
    public Number getStatementNumberAsNumber() {
        return this.getMessageIndexAsNumber();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    @Deprecated
    public Number getComponent2AsNumber() {
        Long l = this.getComponent2AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getTotal() {
        return this.getComponent2();
    }

    @Deprecated
    public String getSequenceNumber() {
        return this.getTotal();
    }

    public Long getTotalAsLong() {
        return this.getComponent2AsLong();
    }

    @Deprecated
    public Number getTotalAsNumber() {
        return this.getComponent2AsNumber();
    }

    @Deprecated
    public Long getSequenceNumberAsLong() {
        return this.getTotalAsLong();
    }

    @Deprecated
    public Number getSequenceNumberAsNumber() {
        return this.getTotalAsNumber();
    }

    public Field28D setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field28D setComponent1(Long component1) {
        this.setComponent(1, SwiftFormatUtils.getLong(component1));
        return this;
    }

    public Field28D setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field28D setMessageIndex(String component1) {
        return this.setComponent1(component1);
    }

    public Field28D setMessageIndex(Long component1) {
        return this.setComponent1(component1);
    }

    public Field28D setMessageIndex(Number component1) {
        return this.setComponent1(component1);
    }

    @Deprecated
    public Field28D setStatementNumber(String component1) {
        return this.setMessageIndex(component1);
    }

    @Deprecated
    public Field28D setStatementNumber(Long component1) {
        return this.setMessageIndex(component1);
    }

    @Deprecated
    public Field28D setStatementNumber(Number component1) {
        return this.setMessageIndex(component1);
    }

    public Field28D setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field28D setComponent2(Long component2) {
        this.setComponent(2, SwiftFormatUtils.getLong(component2));
        return this;
    }

    public Field28D setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field28D setTotal(String component2) {
        return this.setComponent2(component2);
    }

    public Field28D setTotal(Long component2) {
        return this.setComponent2(component2);
    }

    public Field28D setTotal(Number component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field28D setSequenceNumber(String component2) {
        return this.setTotal(component2);
    }

    @Deprecated
    public Field28D setSequenceNumber(Long component2) {
        return this.setTotal(component2);
    }

    @Deprecated
    public Field28D setSequenceNumber(Number component2) {
        return this.setTotal(component2);
    }

    @Override
    public String getName() {
        return "28D";
    }

    public static Field28D get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("28D");
        if (t == null) {
            return null;
        }
        return new Field28D(t);
    }

    public static Field28D get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field28D.get(msg.getBlock4());
    }

    public static List<Field28D> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field28D.getAll(msg.getBlock4());
    }

    public static List<Field28D> getAll(SwiftTagListBlock block) {
        ArrayList<Field28D> result = new ArrayList<Field28D>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("28D");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field28D(f));
            }
        }
        return result;
    }

    public static Field28D fromJson(String json) {
        Field28D field = new Field28D();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("statementNumber") != null) {
            field.setComponent1(jsonObject.get("statementNumber").getAsString());
        }
        if (jsonObject.get("messageIndex") != null) {
            field.setComponent1(jsonObject.get("messageIndex").getAsString());
        }
        if (jsonObject.get("sequenceNumber") != null) {
            field.setComponent2(jsonObject.get("sequenceNumber").getAsString());
        }
        if (jsonObject.get("total") != null) {
            field.setComponent2(jsonObject.get("total").getAsString());
        }
        return field;
    }
}

