/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field94G
extends Field
implements Serializable,
GenericField,
MultiLineField {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "94G";
    public static final String F_94G = "94G";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//S[$S]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSS";
    @Deprecated
    public static final String TYPES_PATTERN = "SSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer ADDRESS = 2;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field94G() {
        super(3);
    }

    public Field94G(String value) {
        super(value);
    }

    public Field94G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"94G")) {
            throw new IllegalArgumentException("cannot create field 94G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field94G newInstance(Field94G source) {
        Field94G cp = new Field94G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("94G", value);
    }

    public static Tag emptyTag() {
        return new Tag("94G", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            String line1 = lines.get(0);
            this.setComponent1(SwiftParseUtils.getTokenFirst(line1, ":", "//"));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(line1, "//"));
            if (lines.size() > 1) {
                this.setComponent3(lines.get(1));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.appendInLines(result, 3, 3);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 94G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SSS";
    }

    @Override
    public String typesPattern() {
        return "SSS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//35x[$35x]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Address");
        result.add("Address 2");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "address");
        result.put(3, "address2");
        return result;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getAddressLine1() {
        return this.getComponent2();
    }

    public String getAddress() {
        return this.getAddress(null);
    }

    public String getAddress(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 2; i < 4; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getAddressLine2() {
        return this.getComponent3();
    }

    public Field94G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field94G setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field94G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field94G setAddressLine1(String component2) {
        return this.setComponent2(component2);
    }

    public Field94G setAddress(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 2, 2, 0, lines);
        return this;
    }

    public Field94G setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field94G setAddressLine2(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "94G";
    }

    public static Field94G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("94G");
        if (t == null) {
            return null;
        }
        return new Field94G(t);
    }

    public static Field94G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field94G.get(msg.getBlock4());
    }

    public static List<Field94G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field94G.getAll(msg.getBlock4());
    }

    public static List<Field94G> getAll(SwiftTagListBlock block) {
        ArrayList<Field94G> result = new ArrayList<Field94G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("94G");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field94G(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field94G cp = Field94G.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field94G cp = Field94G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field94G cp = Field94G.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field94G fromJson(String json) {
        Field94G field = new Field94G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("address") != null) {
            field.setComponent2(jsonObject.get("address").getAsString());
        }
        if (jsonObject.get("address2") != null) {
            field.setComponent3(jsonObject.get("address2").getAsString());
        }
        return field;
    }
}

