/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware;

import com.prowidesoftware.ProwideLocale;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.logging.Logger;

public class ProwideException
extends RuntimeException {
    private static final long serialVersionUID = 4645197208853563727L;
    private static final transient Logger log = Logger.getLogger(ProwideException.class.getName());
    private final Map<String, String> variables = new HashMap<String, String>();

    public ProwideException() {
    }

    public ProwideException(String message, Throwable cause) {
        super(message, cause);
    }

    public ProwideException(String message) {
        super(message);
    }

    public ProwideException(Throwable cause) {
        super(cause);
    }

    public static ResourceBundle getBundle() {
        return ProwideLocale.getBundle(ProwideException.class.getSimpleName());
    }

    public static ResourceBundle getBundle(Locale locale) {
        return ProwideLocale.getBundle(ProwideException.class.getSimpleName(), locale);
    }

    public String getMessage(Locale locale) {
        return this.getMessage(locale, null);
    }

    @Override
    public String getMessage() {
        return this.getMessage(null, null);
    }

    protected String getMessage(Locale locale, Map<String, String> variables) {
        ResourceBundle bundle;
        try {
            bundle = locale == null ? ProwideException.getBundle() : ProwideException.getBundle(locale);
        }
        catch (MissingResourceException ignored) {
            String lan = locale != null ? locale.getLanguage() : "en";
            return "Missing resource bundle. Please check that " + ProwideException.class.getSimpleName() + "_" + lan + ".properties is present in the classpath";
        }
        String key = this.getClass().getSimpleName();
        try {
            String msg = bundle.getString(key);
            msg = ProwideException.substitute(msg, this.variables);
            return ProwideException.substitute(msg, variables);
        }
        catch (MissingResourceException ignored) {
            log.fine("No localized message found for exception key '" + key + "'");
            return super.getMessage();
        }
    }

    static String substitute(String message, Map<String, String> variables) {
        if (message == null) {
            return null;
        }
        if (variables != null && !variables.isEmpty()) {
            for (Map.Entry<String, String> e : variables.entrySet()) {
                message = message.replace("${" + e.getKey() + "}", e.getValue());
            }
        }
        return message;
    }

    protected void addVariable(String key, String value) {
        Objects.requireNonNull(key, "Key required");
        this.variables.put(key, value);
    }

    protected String getVariable(String key) {
        Objects.requireNonNull(key, "Key required");
        return this.variables.get(key);
    }
}

