/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field31X
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "31X";
    public static final String F_31X = "31X";
    @Deprecated
    public static final String PARSER_PATTERN = "(<DATE2>[<HHMM>])|S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "EHS";
    @Deprecated
    public static final String TYPES_PATTERN = "EHS";
    public static final Integer DATE = 1;
    public static final Integer TIME = 2;
    public static final Integer CODE = 3;

    public Field31X() {
        super(3);
    }

    public Field31X(String value) {
        super(value);
    }

    public Field31X(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"31X")) {
            throw new IllegalArgumentException("cannot create field 31X from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field31X newInstance(Field31X source) {
        Field31X cp = new Field31X();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("31X", value);
    }

    public static Tag emptyTag() {
        return new Tag("31X", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        if (value != null) {
            if (SwiftParseUtils.isAllAsciiDigits(value)) {
                if (value.length() > 6) {
                    this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
                    this.setComponent2(StringUtils.substring((String)value, (int)6));
                } else {
                    this.setComponent1(value);
                }
            } else {
                this.setComponent3(value);
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null || this.getComponent2() != null) {
            this.append(result, 1);
            this.append(result, 2);
        } else {
            this.append(result, 3);
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 31X");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return this.getComponent(3);
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "EHS";
    }

    @Override
    public String typesPattern() {
        return "EHS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "(<DATE2>[<HHMM>])|7!a";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Time");
        result.add("Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "time");
        result.put(3, "code");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("time", 2);
        this.labelMap.put("code", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent2();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getCode() {
        return this.getComponent3();
    }

    public Field31X setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field31X setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field31X setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field31X setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field31X setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field31X setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field31X setTime(String component2) {
        return this.setComponent2(component2);
    }

    public Field31X setTime(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field31X setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field31X setCode(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "31X";
    }

    public static Field31X get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("31X");
        if (t == null) {
            return null;
        }
        return new Field31X(t);
    }

    public static Field31X get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field31X.get(msg.getBlock4());
    }

    public static List<Field31X> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field31X.getAll(msg.getBlock4());
    }

    public static List<Field31X> getAll(SwiftTagListBlock block) {
        ArrayList<Field31X> result = new ArrayList<Field31X>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("31X");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field31X(f));
            }
        }
        return result;
    }

    public static Field31X fromJson(String json) {
        Field31X field = new Field31X();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent3(jsonObject.get("code").getAsString());
        }
        return field;
    }
}

