/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field35B
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "35B";
    public static final String F_35B = "35B";
    @Deprecated
    public static final String PARSER_PATTERN = "[<ISIN><SPACE>S][$S]0-4";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    @Deprecated
    public static final String TYPES_PATTERN = "SSSSSS";
    public static final Integer QUALIFIER = 1;
    public static final Integer ISIN = 2;
    public static final Integer IDENTIFICATION_OF_INSTRUMENT = 2;
    public static final Integer IDENTIFICATION_OF_SECURITY = 2;
    public static final Integer DESCRIPTION = 3;
    public static final Integer DESCRIPTION_OF_INSTRUMENT = 3;
    public static final Integer DESCRIPTION_OF_SECURITY = 3;

    public Field35B() {
        super(6);
    }

    public Field35B(String value) {
        super(value);
    }

    public Field35B(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"35B")) {
            throw new IllegalArgumentException("cannot create field 35B from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field35B newInstance(Field35B source) {
        Field35B cp = new Field35B();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("35B", value);
    }

    public static Tag emptyTag() {
        return new Tag("35B", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty() && StringUtils.startsWith((CharSequence)lines.get(0), (CharSequence)"ISIN ")) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), " "));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(lines.get(0), " "));
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 1, lines);
        } else {
            SwiftParseUtils.setComponentsFromLines(this, 3, null, 0, lines);
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            if (result.length() > 0) {
                result.append(" ");
            }
            result.append(this.getComponent2());
        }
        this.appendInLines(result, 3, 6);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 35B");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        return this.getComponent(6);
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SSSSSS";
    }

    @Override
    public String typesPattern() {
        return "SSSSSS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "[<ISIN> 12!c][$][35x][$35x]0-3(****)";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("ISIN");
        result.add("Description");
        result.add("Description 2");
        result.add("Description 3");
        result.add("Description 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "iSIN");
        result.put(3, "description");
        result.put(4, "description2");
        result.put(5, "description3");
        result.put(6, "description4");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("isin", 2);
        this.labelMap.put("identificationofinstrument", 2);
        this.labelMap.put("identificationofsecurity", 2);
        this.labelMap.put("description", 3);
        this.labelMap.put("descriptionofinstrument", 3);
        this.labelMap.put("descriptionofsecurity", 3);
        this.labelMap.put("description2", 4);
        this.labelMap.put("descriptionofinstrument2", 4);
        this.labelMap.put("descriptionofsecurity2", 4);
        this.labelMap.put("description3", 5);
        this.labelMap.put("descriptionofinstrument3", 5);
        this.labelMap.put("descriptionofsecurity3", 5);
        this.labelMap.put("description4", 6);
        this.labelMap.put("descriptionofinstrument4", 6);
        this.labelMap.put("descriptionofsecurity4", 6);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getISIN() {
        return this.getComponent2();
    }

    public String getIdentificationOfInstrument() {
        return this.getISIN();
    }

    public String getIdentificationOfSecurity() {
        return this.getISIN();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getDescriptionLine1() {
        return this.getComponent3();
    }

    public String getDescriptionOfInstrumentLine1() {
        return this.getDescriptionLine1();
    }

    public String getDescriptionOfSecurityLine1() {
        return this.getDescriptionLine1();
    }

    public String getDescription() {
        return this.getDescription(null);
    }

    public String getDescription(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 3; i < 7; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getDescriptionOfInstrument() {
        return this.getDescription();
    }

    public String getDescriptionOfInstrument(CharSequence deli) {
        return this.getDescription(deli);
    }

    public String getDescriptionOfSecurity() {
        return this.getDescription();
    }

    public String getDescriptionOfSecurity(CharSequence deli) {
        return this.getDescription(deli);
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getDescriptionLine2() {
        return this.getComponent4();
    }

    public String getDescriptionOfInstrumentLine2() {
        return this.getDescriptionLine2();
    }

    public String getDescriptionOfSecurityLine2() {
        return this.getDescriptionLine2();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getDescriptionLine3() {
        return this.getComponent5();
    }

    public String getDescriptionOfInstrumentLine3() {
        return this.getDescriptionLine3();
    }

    public String getDescriptionOfSecurityLine3() {
        return this.getDescriptionLine3();
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public String getDescriptionLine4() {
        return this.getComponent6();
    }

    public String getDescriptionOfInstrumentLine4() {
        return this.getDescriptionLine4();
    }

    public String getDescriptionOfSecurityLine4() {
        return this.getDescriptionLine4();
    }

    public Field35B setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field35B setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field35B setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field35B setISIN(String component2) {
        return this.setComponent2(component2);
    }

    public Field35B setIdentificationOfInstrument(String component2) {
        return this.setISIN(component2);
    }

    public Field35B setIdentificationOfSecurity(String component2) {
        return this.setISIN(component2);
    }

    public Field35B setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field35B setDescriptionLine1(String component3) {
        return this.setComponent3(component3);
    }

    public Field35B setDescriptionOfInstrumentLine1(String component3) {
        return this.setDescriptionLine1(component3);
    }

    public Field35B setDescriptionOfSecurityLine1(String component3) {
        return this.setDescriptionLine1(component3);
    }

    public Field35B setDescription(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 3, 4, 0, lines);
        return this;
    }

    public Field35B setDescriptionOfInstrument(String value) {
        return this.setDescription(value);
    }

    public Field35B setDescriptionOfSecurity(String value) {
        return this.setDescription(value);
    }

    public Field35B setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field35B setDescriptionLine2(String component4) {
        return this.setComponent4(component4);
    }

    public Field35B setDescriptionOfInstrumentLine2(String component4) {
        return this.setDescriptionLine2(component4);
    }

    public Field35B setDescriptionOfSecurityLine2(String component4) {
        return this.setDescriptionLine2(component4);
    }

    public Field35B setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field35B setDescriptionLine3(String component5) {
        return this.setComponent5(component5);
    }

    public Field35B setDescriptionOfInstrumentLine3(String component5) {
        return this.setDescriptionLine3(component5);
    }

    public Field35B setDescriptionOfSecurityLine3(String component5) {
        return this.setDescriptionLine3(component5);
    }

    public Field35B setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field35B setDescriptionLine4(String component6) {
        return this.setComponent6(component6);
    }

    public Field35B setDescriptionOfInstrumentLine4(String component6) {
        return this.setDescriptionLine4(component6);
    }

    public Field35B setDescriptionOfSecurityLine4(String component6) {
        return this.setDescriptionLine4(component6);
    }

    @Override
    public String getName() {
        return "35B";
    }

    public static Field35B get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("35B");
        if (t == null) {
            return null;
        }
        return new Field35B(t);
    }

    public static Field35B get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field35B.get(msg.getBlock4());
    }

    public static List<Field35B> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field35B.getAll(msg.getBlock4());
    }

    public static List<Field35B> getAll(SwiftTagListBlock block) {
        ArrayList<Field35B> result = new ArrayList<Field35B>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("35B");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field35B(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field35B cp = Field35B.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field35B cp = Field35B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field35B cp = Field35B.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field35B fromJson(String json) {
        Field35B field = new Field35B();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("identificationOfInstrument") != null) {
            field.setComponent2(jsonObject.get("identificationOfInstrument").getAsString());
        }
        if (jsonObject.get("identificationOfSecurity") != null) {
            field.setComponent2(jsonObject.get("identificationOfSecurity").getAsString());
        }
        if (jsonObject.get("iSIN") != null) {
            field.setComponent2(jsonObject.get("iSIN").getAsString());
        }
        if (jsonObject.get("descriptionOfInstrument") != null) {
            field.setComponent3(jsonObject.get("descriptionOfInstrument").getAsString());
        }
        if (jsonObject.get("descriptionOfSecurity") != null) {
            field.setComponent3(jsonObject.get("descriptionOfSecurity").getAsString());
        }
        if (jsonObject.get("description") != null) {
            field.setComponent3(jsonObject.get("description").getAsString());
        }
        if (jsonObject.get("descriptionOfInstrument2") != null) {
            field.setComponent4(jsonObject.get("descriptionOfInstrument2").getAsString());
        }
        if (jsonObject.get("descriptionOfSecurity2") != null) {
            field.setComponent4(jsonObject.get("descriptionOfSecurity2").getAsString());
        }
        if (jsonObject.get("description2") != null) {
            field.setComponent4(jsonObject.get("description2").getAsString());
        }
        if (jsonObject.get("descriptionOfInstrument3") != null) {
            field.setComponent5(jsonObject.get("descriptionOfInstrument3").getAsString());
        }
        if (jsonObject.get("descriptionOfSecurity3") != null) {
            field.setComponent5(jsonObject.get("descriptionOfSecurity3").getAsString());
        }
        if (jsonObject.get("description3") != null) {
            field.setComponent5(jsonObject.get("description3").getAsString());
        }
        if (jsonObject.get("descriptionOfInstrument4") != null) {
            field.setComponent6(jsonObject.get("descriptionOfInstrument4").getAsString());
        }
        if (jsonObject.get("descriptionOfSecurity4") != null) {
            field.setComponent6(jsonObject.get("descriptionOfSecurity4").getAsString());
        }
        if (jsonObject.get("description4") != null) {
            field.setComponent6(jsonObject.get("description4").getAsString());
        }
        return field;
    }
}

