/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field38G
extends Field
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "38G";
    public static final String F_38G = "38G";
    @Deprecated
    public static final String PARSER_PATTERN = "NS/NS";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "NSNS";
    @Deprecated
    public static final String TYPES_PATTERN = "NSNS";
    public static final Integer NUMBER_FROM = 1;
    public static final Integer PERIOD_FROM = 2;
    public static final Integer NUMBER_TO = 3;
    public static final Integer PERIOD_TO = 4;

    public Field38G() {
        super(4);
    }

    public Field38G(String value) {
        super(value);
    }

    public Field38G(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"38G")) {
            throw new IllegalArgumentException("cannot create field 38G from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field38G newInstance(Field38G source) {
        Field38G cp = new Field38G();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("38G", value);
    }

    public static Tag emptyTag() {
        return new Tag("38G", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getNumericPrefix(StringUtils.substringBefore((String)value, (String)"/")));
        this.setComponent2(SwiftParseUtils.getAlphaSuffix(StringUtils.substringBefore((String)value, (String)"/")));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "/");
        this.setComponent3(SwiftParseUtils.getNumericPrefix(toparse));
        this.setComponent4(SwiftParseUtils.getAlphaSuffix(toparse));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 38G");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return this.getComponent(4);
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "NSNS";
    }

    @Override
    public String typesPattern() {
        return "NSNS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "2n1a/2n1a";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Number From");
        result.add("Period From");
        result.add("Number To");
        result.add("Period To");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "numberFrom");
        result.put(2, "periodFrom");
        result.put(3, "numberTo");
        result.put(4, "periodTo");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("numberfrom", 1);
        this.labelMap.put("periodfrom", 2);
        this.labelMap.put("numberto", 3);
        this.labelMap.put("periodto", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    @Deprecated
    public Number getComponent1AsNumber() {
        Long l = this.getComponent1AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getNumberFrom() {
        return this.getComponent1();
    }

    public Long getNumberFromAsLong() {
        return this.getComponent1AsLong();
    }

    @Deprecated
    public Number getNumberFromAsNumber() {
        return this.getComponent1AsNumber();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPeriodFrom() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Long getComponent3AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        Long l = this.getComponent3AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getNumberTo() {
        return this.getComponent3();
    }

    public Long getNumberToAsLong() {
        return this.getComponent3AsLong();
    }

    @Deprecated
    public Number getNumberToAsNumber() {
        return this.getComponent3AsNumber();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getPeriodTo() {
        return this.getComponent4();
    }

    public Field38G setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field38G setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field38G setNumberFrom(String component1) {
        return this.setComponent1(component1);
    }

    public Field38G setNumberFrom(Number component1) {
        return this.setComponent1(component1);
    }

    public Field38G setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field38G setPeriodFrom(String component2) {
        return this.setComponent2(component2);
    }

    public Field38G setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field38G setComponent3(Number component3) {
        if (component3 instanceof Long) {
            this.setComponent(3, SwiftFormatUtils.getLong((Long)component3));
        } else if (component3 instanceof BigInteger || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field38G setNumberTo(String component3) {
        return this.setComponent3(component3);
    }

    public Field38G setNumberTo(Number component3) {
        return this.setComponent3(component3);
    }

    public Field38G setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field38G setPeriodTo(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "38G";
    }

    public static Field38G get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("38G");
        if (t == null) {
            return null;
        }
        return new Field38G(t);
    }

    public static Field38G get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field38G.get(msg.getBlock4());
    }

    public static List<Field38G> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field38G.getAll(msg.getBlock4());
    }

    public static List<Field38G> getAll(SwiftTagListBlock block) {
        ArrayList<Field38G> result = new ArrayList<Field38G>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("38G");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field38G(f));
            }
        }
        return result;
    }

    public static Field38G fromJson(String json) {
        Field38G field = new Field38G();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("numberFrom") != null) {
            field.setComponent1(jsonObject.get("numberFrom").getAsString());
        }
        if (jsonObject.get("periodFrom") != null) {
            field.setComponent2(jsonObject.get("periodFrom").getAsString());
        }
        if (jsonObject.get("numberTo") != null) {
            field.setComponent3(jsonObject.get("numberTo").getAsString());
        }
        if (jsonObject.get("periodTo") != null) {
            field.setComponent4(jsonObject.get("periodTo").getAsString());
        }
        return field;
    }
}

