/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field42M
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "42M";
    public static final String F_42M = "42M";
    @Deprecated
    public static final String PARSER_PATTERN = "S[$S]0-3";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSS";
    @Deprecated
    public static final String TYPES_PATTERN = "SSSS";
    public static final Integer NARRATIVE = 1;

    public Field42M() {
        super(4);
    }

    public Field42M(String value) {
        super(value);
    }

    public Field42M(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"42M")) {
            throw new IllegalArgumentException("cannot create field 42M from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field42M newInstance(Field42M source) {
        Field42M cp = new Field42M();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("42M", value);
    }

    public static Tag emptyTag() {
        return new Tag("42M", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, null, 0, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 42M");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return this.getComponent(4);
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SSSS";
    }

    @Override
    public String typesPattern() {
        return "SSSS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "35x[$35x]0-3";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        return component == 4;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Narrative");
        result.add("Narrative 2");
        result.add("Narrative 3");
        result.add("Narrative 4");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "narrative");
        result.put(2, "narrative2");
        result.put(3, "narrative3");
        result.put(4, "narrative4");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("narrative", 1);
        this.labelMap.put("narrative2", 2);
        this.labelMap.put("narrative3", 3);
        this.labelMap.put("narrative4", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getNarrativeLine1() {
        return this.getComponent1();
    }

    public String getNarrative() {
        return this.getNarrative(null);
    }

    public String getNarrative(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < 5; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrativeLine2() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getNarrativeLine3() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getNarrativeLine4() {
        return this.getComponent4();
    }

    public Field42M setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field42M setNarrativeLine1(String component1) {
        return this.setComponent1(component1);
    }

    public Field42M setNarrative(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, 4, 0, lines);
        return this;
    }

    public Field42M setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field42M setNarrativeLine2(String component2) {
        return this.setComponent2(component2);
    }

    public Field42M setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field42M setNarrativeLine3(String component3) {
        return this.setComponent3(component3);
    }

    public Field42M setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field42M setNarrativeLine4(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "42M";
    }

    public static Field42M get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("42M");
        if (t == null) {
            return null;
        }
        return new Field42M(t);
    }

    public static Field42M get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field42M.get(msg.getBlock4());
    }

    public static List<Field42M> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field42M.getAll(msg.getBlock4());
    }

    public static List<Field42M> getAll(SwiftTagListBlock block) {
        ArrayList<Field42M> result = new ArrayList<Field42M>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("42M");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field42M(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field42M cp = Field42M.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field42M cp = Field42M.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field42M cp = Field42M.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field42M fromJson(String json) {
        Field42M field = new Field42M();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("narrative") != null) {
            field.setComponent1(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("narrative2") != null) {
            field.setComponent2(jsonObject.get("narrative2").getAsString());
        }
        if (jsonObject.get("narrative3") != null) {
            field.setComponent3(jsonObject.get("narrative3").getAsString());
        }
        if (jsonObject.get("narrative4") != null) {
            field.setComponent4(jsonObject.get("narrative4").getAsString());
        }
        return field;
    }
}

