/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field48
extends Field
implements Serializable {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "48";
    public static final String F_48 = "48";
    @Deprecated
    public static final String PARSER_PATTERN = "S[/S]";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "NS";
    @Deprecated
    public static final String TYPES_PATTERN = "NS";
    public static final Integer DAYS = 1;
    public static final Integer NARRATIVE = 2;

    public Field48() {
        super(2);
    }

    public Field48(String value) {
        super(value);
    }

    public Field48(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"48")) {
            throw new IllegalArgumentException("cannot create field 48 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field48 newInstance(Field48 source) {
        Field48 cp = new Field48();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("48", value);
    }

    public static Tag emptyTag() {
        return new Tag("48", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 48");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "NS";
    }

    @Override
    public String typesPattern() {
        return "NS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "3n[/35x]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Days");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "days");
        result.put(2, "narrative");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("days", 1);
        this.labelMap.put("narrative", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    @Deprecated
    public Number getComponent1AsNumber() {
        Long l = this.getComponent1AsLong();
        return l != null ? new BigDecimal(l) : null;
    }

    public String getDays() {
        return this.getComponent1();
    }

    public Long getDaysAsLong() {
        return this.getComponent1AsLong();
    }

    @Deprecated
    public Number getDaysAsNumber() {
        return this.getComponent1AsNumber();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrative() {
        return this.getComponent2();
    }

    public Field48 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field48 setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field48 setDays(String component1) {
        return this.setComponent1(component1);
    }

    public Field48 setDays(Number component1) {
        return this.setComponent1(component1);
    }

    public Field48 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field48 setNarrative(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "48";
    }

    public static Field48 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("48");
        if (t == null) {
            return null;
        }
        return new Field48(t);
    }

    public static Field48 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field48.get(msg.getBlock4());
    }

    public static List<Field48> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field48.getAll(msg.getBlock4());
    }

    public static List<Field48> getAll(SwiftTagListBlock block) {
        ArrayList<Field48> result = new ArrayList<Field48>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("48");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field48(f));
            }
        }
        return result;
    }

    public static Field48 fromJson(String json) {
        Field48 field = new Field48();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("days") != null) {
            field.setComponent1(jsonObject.get("days").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

