/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field92M
extends Field
implements Serializable,
MonetaryAmountContainer,
GenericField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "92M";
    public static final String F_92M = "92M";
    @Deprecated
    public static final String PARSER_PATTERN = ":S//SN/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SCNN";
    @Deprecated
    public static final String TYPES_PATTERN = "SCII";
    public static final Integer QUALIFIER = 1;
    public static final Integer CURRENCY_CODE = 2;
    @Deprecated
    public static final Integer CURRENCY = 2;
    public static final Integer AMOUNT = 3;
    public static final Integer QUANTITY = 4;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field92M() {
        super(4);
    }

    public Field92M(String value) {
        super(value);
    }

    public Field92M(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"92M")) {
            throw new IllegalArgumentException("cannot create field 92M from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field92M newInstance(Field92M source) {
        Field92M cp = new Field92M();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("92M", value);
    }

    public static Tag emptyTag() {
        return new Tag("92M", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "//"));
        String toparse = SwiftParseUtils.getTokenSecondLast(value, "//");
        String toparse2 = SwiftParseUtils.getTokenFirst(toparse, "/");
        this.setComponent4(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
        this.setComponent2(SwiftParseUtils.getAlphaPrefixTrimSlash(toparse2));
        this.setComponent3(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("//");
        this.append(result, 2);
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        BigDecimal n;
        NumberFormat f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 92M");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            n = this.getComponent3AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        f = NumberFormat.getNumberInstance(this.notNull(locale));
        f.setMaximumFractionDigits(13);
        n = this.getComponent4AsBigDecimal();
        if (n != null) {
            return f.format(n);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return COMPONENTS_PATTERN;
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c//<CUR><AMOUNT>15/<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Currency Code");
        result.add("Amount");
        result.add("Quantity");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "currencyCode");
        result.put(3, "amount");
        result.put(4, "quantity");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("currencycode", 2);
        this.labelMap.put("currency", 2);
        this.labelMap.put("amount", 3);
        this.labelMap.put("quantity", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Currency getComponent2AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(2));
    }

    public String getCurrencyCode() {
        return this.getComponent2();
    }

    @Deprecated
    public String getCurrency() {
        return this.getCurrencyCode();
    }

    public Currency getCurrencyCodeAsCurrency() {
        return this.getComponent2AsCurrency();
    }

    @Deprecated
    public Currency getCurrencyAsCurrency() {
        return this.getCurrencyCodeAsCurrency();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        return this.getComponent3AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent3();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent3AsNumber();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BigDecimal getComponent4AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(4));
    }

    @Deprecated
    public Number getComponent4AsNumber() {
        return this.getComponent4AsBigDecimal();
    }

    public String getQuantity() {
        return this.getComponent4();
    }

    public BigDecimal getQuantityAsBigDecimal() {
        return this.getComponent4AsBigDecimal();
    }

    @Deprecated
    public Number getQuantityAsNumber() {
        return this.getComponent4AsNumber();
    }

    public Field92M setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field92M setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field92M setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field92M setComponent2(Currency component2) {
        this.setComponent(2, SwiftFormatUtils.getCurrency(component2));
        return this;
    }

    public Field92M setCurrencyCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field92M setCurrencyCode(Currency component2) {
        return this.setComponent2(component2);
    }

    @Deprecated
    public Field92M setCurrency(String component2) {
        return this.setCurrencyCode(component2);
    }

    @Deprecated
    public Field92M setCurrency(Currency component2) {
        return this.setCurrencyCode(component2);
    }

    public Field92M setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field92M setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field92M setAmount(String component3) {
        return this.setComponent3(component3);
    }

    public Field92M setAmount(Number component3) {
        return this.setComponent3(component3);
    }

    public Field92M setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field92M setComponent4(Number component4) {
        if (component4 instanceof BigDecimal) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal((BigDecimal)component4));
        } else if (component4 instanceof BigInteger) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component4)));
        } else if (component4 instanceof Long || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.longValue())));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.doubleValue())));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field92M setQuantity(String component4) {
        return this.setComponent4(component4);
    }

    public Field92M setQuantity(Number component4) {
        return this.setComponent4(component4);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "92M";
    }

    public static Field92M get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("92M");
        if (t == null) {
            return null;
        }
        return new Field92M(t);
    }

    public static Field92M get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field92M.get(msg.getBlock4());
    }

    public static List<Field92M> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field92M.getAll(msg.getBlock4());
    }

    public static List<Field92M> getAll(SwiftTagListBlock block) {
        ArrayList<Field92M> result = new ArrayList<Field92M>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("92M");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field92M(f));
            }
        }
        return result;
    }

    public static Field92M fromJson(String json) {
        Field92M field = new Field92M();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent2(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("currencyCode") != null) {
            field.setComponent2(jsonObject.get("currencyCode").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("quantity") != null) {
            field.setComponent4(jsonObject.get("quantity").getAsString());
        }
        return field;
    }
}

