/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field98K
extends Field
implements Serializable,
DateContainer,
GenericField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "98K";
    public static final String F_98K = "98K";
    @Deprecated
    public static final String PARSER_PATTERN = ":S/S/<DATE4><TIME2>/S";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSDTS";
    @Deprecated
    public static final String TYPES_PATTERN = "SSDTS";
    public static final Integer QUALIFIER = 1;
    public static final Integer DATA_SOURCE_SCHEME = 2;
    public static final Integer DATE = 3;
    public static final Integer TIME = 4;
    public static final Integer PROPRIETARY_CODE = 5;
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field98K() {
        super(5);
    }

    public Field98K(String value) {
        super(value);
    }

    public Field98K(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"98K")) {
            throw new IllegalArgumentException("cannot create field 98K from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field98K newInstance(Field98K source) {
        Field98K cp = new Field98K();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("98K", value);
    }

    public static Tag emptyTag() {
        return new Tag("98K", "");
    }

    @Override
    public void parse(String value) {
        this.init(5);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, ":", "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecond(value, "/"));
        String toparse = SwiftParseUtils.getTokenThirdLast(value, "/");
        this.setComponent5(SwiftParseUtils.getTokenSecondLast(toparse, "/"));
        String toparseDateTime = SwiftParseUtils.getTokenFirst(toparse, "/");
        if (toparseDateTime != null) {
            if (toparseDateTime.length() >= 8) {
                this.setComponent3(StringUtils.substring((String)toparseDateTime, (int)0, (int)8));
            }
            if (toparseDateTime.length() > 8) {
                this.setComponent4(StringUtils.substring((String)toparseDateTime, (int)8));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(":");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        result.append("/");
        this.append(result, 3);
        this.append(result, 4);
        result.append("/");
        this.append(result, 5);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 5) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 98K");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent3AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 4) {
            f = new SimpleDateFormat("HH:mm:ss", this.notNull(locale));
            cal = this.getComponent4AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return this.getComponent(5);
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SSDTS";
    }

    @Override
    public String typesPattern() {
        return "SSDTS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return ":4!c/8c/<DATE4><TIME2>/34x(***)";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return true;
    }

    @Override
    public int componentsSize() {
        return 5;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Qualifier");
        result.add("Data Source Scheme");
        result.add("Date");
        result.add("Time");
        result.add("Proprietary Code");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "qualifier");
        result.put(2, "dataSourceScheme");
        result.put(3, "date");
        result.put(4, "time");
        result.put(5, "proprietaryCode");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("qualifier", 1);
        this.labelMap.put("datasourcescheme", 2);
        this.labelMap.put("date", 3);
        this.labelMap.put("time", 4);
        this.labelMap.put("proprietarycode", 5);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getQualifier() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDataSourceScheme() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(3));
    }

    public String getDate() {
        return this.getComponent3();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent3AsCalendar();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public Calendar getComponent4AsCalendar() {
        return SwiftFormatUtils.getTime2(this.getComponent(4));
    }

    public String getTime() {
        return this.getComponent4();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent4AsCalendar();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getProprietaryCode() {
        return this.getComponent5();
    }

    public Field98K setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field98K setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field98K setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field98K setDataSourceScheme(String component2) {
        return this.setComponent2(component2);
    }

    public Field98K setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field98K setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getDate4(component3));
        return this;
    }

    public Field98K setDate(String component3) {
        return this.setComponent3(component3);
    }

    public Field98K setDate(Calendar component3) {
        return this.setComponent3(component3);
    }

    public Field98K setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field98K setComponent4(Calendar component4) {
        this.setComponent(4, SwiftFormatUtils.getTime2(component4));
        return this;
    }

    public Field98K setTime(String component4) {
        return this.setComponent4(component4);
    }

    public Field98K setTime(Calendar component4) {
        return this.setComponent4(component4);
    }

    public Field98K setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field98K setProprietaryCode(String component5) {
        return this.setComponent5(component5);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "98K";
    }

    public static Field98K get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("98K");
        if (t == null) {
            return null;
        }
        return new Field98K(t);
    }

    public static Field98K get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field98K.get(msg.getBlock4());
    }

    public static List<Field98K> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field98K.getAll(msg.getBlock4());
    }

    public static List<Field98K> getAll(SwiftTagListBlock block) {
        ArrayList<Field98K> result = new ArrayList<Field98K>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("98K");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field98K(f));
            }
        }
        return result;
    }

    public static Field98K fromJson(String json) {
        Field98K field = new Field98K();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("dataSourceScheme") != null) {
            field.setComponent2(jsonObject.get("dataSourceScheme").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent3(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent4(jsonObject.get("time").getAsString());
        }
        if (jsonObject.get("proprietaryCode") != null) {
            field.setComponent5(jsonObject.get("proprietaryCode").getAsString());
        }
        return field;
    }
}

