/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field35E
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "35E";
    public static final String F_35E = "35E";
    @Deprecated
    public static final String PARSER_PATTERN = "S[$S]0-5";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "SSSSSS";
    @Deprecated
    public static final String TYPES_PATTERN = "SSSSSS";
    public static final Integer NARRATIVE = 1;

    public Field35E() {
        super(6);
    }

    public Field35E(String value) {
        super(value);
    }

    public Field35E(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"35E")) {
            throw new IllegalArgumentException("cannot create field 35E from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field35E newInstance(Field35E source) {
        Field35E cp = new Field35E();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("35E", value);
    }

    public static Tag emptyTag() {
        return new Tag("35E", "");
    }

    @Override
    public void parse(String value) {
        this.init(6);
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, null, 0, lines);
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.appendInLines(result, 1, 6);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 6) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 35E");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        if (component == 5) {
            return this.getComponent(5);
        }
        if (component == 6) {
            return this.getComponent(6);
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "SSSSSS";
    }

    @Override
    public String typesPattern() {
        return "SSSSSS";
    }

    @Override
    public String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public String validatorPattern() {
        return "50x[$50x]0-5";
    }

    @Override
    public boolean isOptional(int component) {
        if (component == 2) {
            return true;
        }
        if (component == 3) {
            return true;
        }
        if (component == 4) {
            return true;
        }
        if (component == 5) {
            return true;
        }
        return component == 6;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 6;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Narrative");
        result.add("Narrative 2");
        result.add("Narrative 3");
        result.add("Narrative 4");
        result.add("Narrative 5");
        result.add("Narrative 6");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "narrative");
        result.put(2, "narrative2");
        result.put(3, "narrative3");
        result.put(4, "narrative4");
        result.put(5, "narrative5");
        result.put(6, "narrative6");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("narrative", 1);
        this.labelMap.put("narrative2", 2);
        this.labelMap.put("narrative3", 3);
        this.labelMap.put("narrative4", 4);
        this.labelMap.put("narrative5", 5);
        this.labelMap.put("narrative6", 6);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getNarrativeLine1() {
        return this.getComponent1();
    }

    public String getNarrative() {
        return this.getNarrative(null);
    }

    public String getNarrative(CharSequence deli) {
        StringBuilder result = new StringBuilder();
        for (int i = 1; i < 7; ++i) {
            if (this.getComponent(i) == null) continue;
            if (deli != null && result.length() > 0) {
                result.append(deli);
            }
            result.append(this.getComponent(i));
        }
        return result.toString();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrativeLine2() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getNarrativeLine3() {
        return this.getComponent3();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getNarrativeLine4() {
        return this.getComponent4();
    }

    public String getComponent5() {
        return this.getComponent(5);
    }

    public String getNarrativeLine5() {
        return this.getComponent5();
    }

    public String getComponent6() {
        return this.getComponent(6);
    }

    public String getNarrativeLine6() {
        return this.getComponent6();
    }

    public Field35E setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field35E setNarrativeLine1(String component1) {
        return this.setComponent1(component1);
    }

    public Field35E setNarrative(String value) {
        List<String> lines = SwiftParseUtils.getLines(value);
        SwiftParseUtils.setComponentsFromLines(this, 1, 6, 0, lines);
        return this;
    }

    public Field35E setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field35E setNarrativeLine2(String component2) {
        return this.setComponent2(component2);
    }

    public Field35E setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field35E setNarrativeLine3(String component3) {
        return this.setComponent3(component3);
    }

    public Field35E setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field35E setNarrativeLine4(String component4) {
        return this.setComponent4(component4);
    }

    public Field35E setComponent5(String component5) {
        this.setComponent(5, component5);
        return this;
    }

    public Field35E setNarrativeLine5(String component5) {
        return this.setComponent5(component5);
    }

    public Field35E setComponent6(String component6) {
        this.setComponent(6, component6);
        return this;
    }

    public Field35E setNarrativeLine6(String component6) {
        return this.setComponent6(component6);
    }

    @Override
    public String getName() {
        return "35E";
    }

    public static Field35E get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("35E");
        if (t == null) {
            return null;
        }
        return new Field35E(t);
    }

    public static Field35E get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field35E.get(msg.getBlock4());
    }

    public static List<Field35E> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field35E.getAll(msg.getBlock4());
    }

    public static List<Field35E> getAll(SwiftTagListBlock block) {
        ArrayList<Field35E> result = new ArrayList<Field35E>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("35E");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field35E(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field35E cp = Field35E.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field35E cp = Field35E.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field35E cp = Field35E.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field35E fromJson(String json) {
        Field35E field = new Field35E();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("narrative") != null) {
            field.setComponent1(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("narrative2") != null) {
            field.setComponent2(jsonObject.get("narrative2").getAsString());
        }
        if (jsonObject.get("narrative3") != null) {
            field.setComponent3(jsonObject.get("narrative3").getAsString());
        }
        if (jsonObject.get("narrative4") != null) {
            field.setComponent4(jsonObject.get("narrative4").getAsString());
        }
        if (jsonObject.get("narrative5") != null) {
            field.setComponent5(jsonObject.get("narrative5").getAsString());
        }
        if (jsonObject.get("narrative6") != null) {
            field.setComponent6(jsonObject.get("narrative6").getAsString());
        }
        return field;
    }
}

