/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.CurrencyContainer;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MonetaryAmountContainer;
import com.prowidesoftware.swift.model.field.MonetaryAmountResolver;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Currency;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field34F
extends Field
implements Serializable,
MonetaryAmountContainer {
    public static final int SRU = 2023;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "34F";
    public static final String F_34F = "34F";
    @Deprecated
    public static final String PARSER_PATTERN = "CSN";
    @Deprecated
    public static final String COMPONENTS_PATTERN = "CSN";
    @Deprecated
    public static final String TYPES_PATTERN = "CSI";
    public static final Integer CURRENCY = 1;
    public static final Integer DC_MARK = 2;
    public static final Integer AMOUNT = 3;

    public Field34F() {
        super(3);
    }

    public Field34F(String value) {
        super(value);
    }

    public Field34F(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"34F")) {
            throw new IllegalArgumentException("cannot create field 34F from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field34F newInstance(Field34F source) {
        Field34F cp = new Field34F();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("34F", value);
    }

    public static Tag emptyTag() {
        return new Tag("34F", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        String toparse = SwiftParseUtils.getAlphaPrefix(value);
        if (toparse != null) {
            if (toparse.length() >= 3) {
                this.setComponent1(StringUtils.substring((String)toparse, (int)0, (int)3));
            }
            if (toparse.length() > 3) {
                this.setComponent2(StringUtils.substring((String)toparse, (int)3));
            }
        }
        this.setComponent3(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 34F");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
            f.setMaximumFractionDigits(13);
            BigDecimal n = this.getComponent3AsBigDecimal();
            if (n != null) {
                return f.format(n);
            }
        }
        return null;
    }

    @Override
    @Deprecated
    public String componentsPattern() {
        return "CSN";
    }

    @Override
    public String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public String parserPattern() {
        return "CSN";
    }

    @Override
    public String validatorPattern() {
        return "<CUR>[<DC>]<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Currency");
        result.add("D/C Mark");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "currency");
        result.put(2, "dCMark");
        result.put(3, "amount");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("currency", 1);
        this.labelMap.put("dcmark", 2);
        this.labelMap.put("amount", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Currency getComponent1AsCurrency() {
        return SwiftFormatUtils.getCurrency(this.getComponent(1));
    }

    public String getCurrency() {
        return this.getComponent1();
    }

    public Currency getCurrencyAsCurrency() {
        return this.getComponent1AsCurrency();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getDCMark() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    @Deprecated
    public Number getComponent3AsNumber() {
        return this.getComponent3AsBigDecimal();
    }

    public String getAmount() {
        return this.getComponent3();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    @Deprecated
    public Number getAmountAsNumber() {
        return this.getComponent3AsNumber();
    }

    public Field34F setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field34F setComponent1(Currency component1) {
        this.setComponent(1, SwiftFormatUtils.getCurrency(component1));
        return this;
    }

    public Field34F setCurrency(String component1) {
        return this.setComponent1(component1);
    }

    public Field34F setCurrency(Currency component1) {
        return this.setComponent1(component1);
    }

    public Field34F setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field34F setDCMark(String component2) {
        return this.setComponent2(component2);
    }

    public Field34F setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field34F setComponent3(BigDecimal component3) {
        this.setComponent(3, SwiftFormatUtils.getBigDecimal(component3));
        return this;
    }

    public Field34F setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field34F setAmount(String component3) {
        return this.setComponent3(component3);
    }

    public Field34F setAmount(BigDecimal component3) {
        return this.setComponent3(component3);
    }

    public Field34F setAmount(Number component3) {
        return this.setComponent3(component3);
    }

    @Override
    public List<String> currencyStrings() {
        return MonetaryAmountResolver.currencyStrings(this);
    }

    @Override
    public List<Currency> currencies() {
        return MonetaryAmountResolver.currencies(this);
    }

    @Override
    public Currency currency() {
        return MonetaryAmountResolver.resolveCurrency(this);
    }

    @Override
    public String currencyString() {
        return MonetaryAmountResolver.resolveCurrencyString(this);
    }

    @Override
    public void initializeCurrencies(String cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    @Override
    public void initializeCurrencies(Currency cur) {
        MonetaryAmountResolver.resolveSetCurrency((CurrencyContainer)this, cur);
    }

    public List<BigDecimal> amounts() {
        return MonetaryAmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return MonetaryAmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "34F";
    }

    public static Field34F get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("34F");
        if (t == null) {
            return null;
        }
        return new Field34F(t);
    }

    public static Field34F get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field34F.get(msg.getBlock4());
    }

    public static List<Field34F> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field34F.getAll(msg.getBlock4());
    }

    public static List<Field34F> getAll(SwiftTagListBlock block) {
        ArrayList<Field34F> result = new ArrayList<Field34F>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("34F");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field34F(f));
            }
        }
        return result;
    }

    public static Field34F fromJson(String json) {
        Field34F field = new Field34F();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("currency") != null) {
            field.setComponent1(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("dCMark") != null) {
            field.setComponent2(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

