/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model;

import org.apache.commons.lang3.StringUtils;

public class DistinguishedName {
    private final String branch;
    private final String bic8;
    private final String swift;

    private DistinguishedName(Builder builder) {
        this.branch = builder.branch;
        this.bic8 = builder.bic8;
        this.swift = builder.swift;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getBic8() {
        return this.bic8;
    }

    public String getSwift() {
        return this.swift;
    }

    public String toString() {
        StringBuilder dn = new StringBuilder();
        if (this.branch != null && !this.branch.isEmpty()) {
            dn.append("ou=").append(this.branch).append(",");
        }
        dn.append("o=").append(this.bic8).append(",o=").append(this.swift);
        return dn.toString();
    }

    public static String parseBIC(String dn) {
        if (StringUtils.isBlank((CharSequence)dn)) {
            return null;
        }
        for (String s : StringUtils.split((String)dn, (String)",")) {
            if (!StringUtils.startsWith((CharSequence)s, (CharSequence)"o=") || StringUtils.equals((CharSequence)s, (CharSequence)"o=swift")) continue;
            return StringUtils.upperCase((String)StringUtils.substringAfter((String)s, (String)"o="));
        }
        return null;
    }

    public static class Builder {
        private String branch;
        private final String bic8;
        private final String swift;

        public Builder(String bic8) {
            this.bic8 = StringUtils.lowerCase((String)bic8);
            this.swift = "swift";
        }

        public Builder withBranch(String ou) {
            this.branch = StringUtils.lowerCase((String)ou);
            return this;
        }

        public DistinguishedName build() {
            return new DistinguishedName(this);
        }
    }
}

