/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field40E
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "40E";
    public static final String F_40E = "40E";
    public static final Integer APPLICABLE_RULES = 1;
    public static final Integer NARRATIVE = 2;

    public Field40E() {
        super(2);
    }

    public Field40E(String value) {
        super(value);
    }

    public Field40E(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"40E")) {
            throw new IllegalArgumentException("cannot create field 40E from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field40E newInstance(Field40E source) {
        Field40E cp = new Field40E();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("40E", value);
    }

    public static Tag emptyTag() {
        return new Tag("40E", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 40E");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "S[/S]";
    }

    @Override
    public String validatorPattern() {
        return "30x[/35x]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Applicable Rules");
        result.add("Narrative");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "applicableRules");
        result.put(2, "narrative");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("applicablerules", 1);
        this.labelMap.put("narrative", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getApplicableRules() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNarrative() {
        return this.getComponent2();
    }

    public Field40E setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field40E setApplicableRules(String component1) {
        return this.setComponent1(component1);
    }

    public Field40E setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field40E setNarrative(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "40E";
    }

    public static Field40E get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("40E");
        if (t == null) {
            return null;
        }
        return new Field40E(t);
    }

    public static Field40E get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field40E.get(msg.getBlock4());
    }

    public static List<Field40E> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field40E.getAll(msg.getBlock4());
    }

    public static List<Field40E> getAll(SwiftTagListBlock block) {
        ArrayList<Field40E> result = new ArrayList<Field40E>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("40E");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field40E(f));
            }
        }
        return result;
    }

    public static Field40E fromJson(String json) {
        Field40E field = new Field40E();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("applicableRules") != null) {
            field.setComponent1(jsonObject.get("applicableRules").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        return field;
    }
}

