/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field26A
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "26A";
    public static final String F_26A = "26A";
    public static final Integer NUMBER1 = 1;
    public static final Integer NUMBER2 = 2;

    public Field26A() {
        super(2);
    }

    public Field26A(String value) {
        super(value);
    }

    public Field26A(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"26A")) {
            throw new IllegalArgumentException("cannot create field 26A from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field26A newInstance(Field26A source) {
        Field26A cp = new Field26A();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("26A", value);
    }

    public static Tag emptyTag() {
        return new Tag("26A", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 26A");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "S[/S]";
    }

    @Override
    public String validatorPattern() {
        return "<VAR-SEQU-2>";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Number1");
        result.add("Number2");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "number1");
        result.put(2, "number2");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("number1", 1);
        this.labelMap.put("number2", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getNumber1() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getNumber2() {
        return this.getComponent2();
    }

    public Field26A setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field26A setNumber1(String component1) {
        return this.setComponent1(component1);
    }

    public Field26A setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field26A setNumber2(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public String getName() {
        return "26A";
    }

    public static Field26A get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("26A");
        if (t == null) {
            return null;
        }
        return new Field26A(t);
    }

    public static Field26A get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field26A.get(msg.getBlock4());
    }

    public static List<Field26A> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field26A.getAll(msg.getBlock4());
    }

    public static List<Field26A> getAll(SwiftTagListBlock block) {
        ArrayList<Field26A> result = new ArrayList<Field26A>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("26A");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field26A(f));
            }
        }
        return result;
    }

    public static Field26A fromJson(String json) {
        Field26A field = new Field26A();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("number1") != null) {
            field.setComponent1(jsonObject.get("number1").getAsString());
        }
        if (jsonObject.get("number2") != null) {
            field.setComponent2(jsonObject.get("number2").getAsString());
        }
        return field;
    }
}

