/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field30I
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "30I";
    public static final String F_30I = "30I";
    public static final Integer START_DATE = 1;
    public static final Integer END_DATE = 2;

    public Field30I() {
        super(2);
    }

    public Field30I(String value) {
        super(value);
    }

    public Field30I(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"30I")) {
            throw new IllegalArgumentException("cannot create field 30I from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field30I newInstance(Field30I source) {
        Field30I cp = new Field30I();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("30I", value);
    }

    public static Tag emptyTag() {
        return new Tag("30I", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 30I");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "DD";
    }

    @Override
    public String parserPattern() {
        return "S[/S]";
    }

    @Override
    public String validatorPattern() {
        return "<DATE4>[/<DATE4>]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Start Date");
        result.add("End Date");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "startDate");
        result.put(2, "endDate");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("startdate", 1);
        this.labelMap.put("dateorstartdate", 1);
        this.labelMap.put("enddate", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getStartDate() {
        return this.getComponent1();
    }

    public Calendar getStartDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(2));
    }

    public String getEndDate() {
        return this.getComponent2();
    }

    public Calendar getEndDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public Field30I setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field30I setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field30I setStartDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field30I setStartDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field30I setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field30I setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate4(component2));
        return this;
    }

    public Field30I setEndDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field30I setEndDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "30I";
    }

    public static Field30I get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("30I");
        if (t == null) {
            return null;
        }
        return new Field30I(t);
    }

    public static Field30I get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field30I.get(msg.getBlock4());
    }

    public static List<Field30I> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field30I.getAll(msg.getBlock4());
    }

    public static List<Field30I> getAll(SwiftTagListBlock block) {
        ArrayList<Field30I> result = new ArrayList<Field30I>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("30I");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field30I(f));
            }
        }
        return result;
    }

    public static Field30I fromJson(String json) {
        Field30I field = new Field30I();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("dateorStartDate") != null) {
            field.setComponent1(jsonObject.get("dateorStartDate").getAsString());
        }
        if (jsonObject.get("startDate") != null) {
            field.setComponent1(jsonObject.get("startDate").getAsString());
        }
        if (jsonObject.get("endDate") != null) {
            field.setComponent2(jsonObject.get("endDate").getAsString());
        }
        return field;
    }
}

