/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.BICContainer;
import com.prowidesoftware.swift.model.field.BICResolver;
import com.prowidesoftware.swift.model.field.GenericField;
import com.prowidesoftware.swift.model.field.OptionPPartyField;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Field95P
extends OptionPPartyField
implements Serializable,
BICContainer,
GenericField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "95P";
    public static final String F_95P = "95P";
    public static final Integer CONDITIONAL_QUALIFIER = 2;

    public Field95P() {
    }

    public Field95P(String value) {
        super(value);
    }

    public Field95P(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"95P")) {
            throw new IllegalArgumentException("cannot create field 95P from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field95P newInstance(Field95P source) {
        Field95P cp = new Field95P();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("95P", value);
    }

    public static Tag emptyTag() {
        return new Tag("95P", "");
    }

    @Override
    public final String validatorPattern() {
        return ":4!c//<BIC>";
    }

    public Field95P setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field95P setQualifier(String component1) {
        return this.setComponent1(component1);
    }

    public Field95P setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field95P setComponent2(BIC component2) {
        this.setComponent(2, SwiftFormatUtils.getBIC(component2));
        return this;
    }

    public Field95P setIdentifierCode(String component2) {
        return this.setComponent2(component2);
    }

    public Field95P setIdentifierCode(BIC component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<BIC> bics() {
        return BICResolver.bics(this);
    }

    @Override
    public List<String> bicStrings() {
        return BICResolver.bicStrings(this);
    }

    @Override
    public String getDSS() {
        return null;
    }

    @Override
    public boolean isDSSPresent() {
        return false;
    }

    @Override
    public String getConditionalQualifier() {
        return this.getComponent(CONDITIONAL_QUALIFIER);
    }

    @Override
    public String getName() {
        return "95P";
    }

    public static Field95P get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("95P");
        if (t == null) {
            return null;
        }
        return new Field95P(t);
    }

    public static Field95P get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field95P.get(msg.getBlock4());
    }

    public static List<Field95P> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field95P.getAll(msg.getBlock4());
    }

    public static List<Field95P> getAll(SwiftTagListBlock block) {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("95P");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field95P(f));
            }
        }
        return result;
    }

    public static Field95P fromJson(String json) {
        Field95P field = new Field95P();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("qualifier") != null) {
            field.setComponent1(jsonObject.get("qualifier").getAsString());
        }
        if (jsonObject.get("bIC") != null) {
            field.setComponent2(jsonObject.get("bIC").getAsString());
        }
        if (jsonObject.get("identifierCode") != null) {
            field.setComponent2(jsonObject.get("identifierCode").getAsString());
        }
        return field;
    }
}

