/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.PartyIdentifier;
import com.prowidesoftware.swift.model.field.PartyIdentifierUtils;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class OptionBPartyField
extends Field
implements PartyIdentifier {
    public static final String PARSER_PATTERN = "[[/c][/S]$][S]";
    public static final String TYPES_PATTERN = "SSS";
    public static final Integer DC_MARK = 1;
    public static final Integer ACCOUNT = 2;
    public static final Integer LOCATION = 3;

    public OptionBPartyField() {
        super(3);
    }

    public OptionBPartyField(String value) {
        super(value);
    }

    @Override
    public void parse(String value) {
        this.init(3);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (lines.isEmpty()) {
            return;
        }
        if (lines.get(0).startsWith("/")) {
            String party = lines.get(0);
            if (StringUtils.startsWith((CharSequence)party, (CharSequence)"/C/") || StringUtils.startsWith((CharSequence)party, (CharSequence)"/D/")) {
                this.setComponent(1, String.valueOf(party.charAt(1)));
                this.setComponent(2, StringUtils.substring((String)party, (int)3));
            } else {
                this.setComponent(2, StringUtils.substring((String)party, (int)1));
            }
            if (lines.size() > 1) {
                this.setComponent(3, lines.get(1));
            }
        } else {
            this.setComponent(3, lines.get(0));
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        if (this.getComponent1() != null) {
            result.append("/").append(this.getComponent1());
        }
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        if (this.getComponent3() != null) {
            if (result.length() > 0) {
                result.append("\r\n");
            }
            result.append(this.getComponent3());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field " + this.getName());
        }
        return this.getComponent(component);
    }

    @Override
    public final String typesPattern() {
        return TYPES_PATTERN;
    }

    @Override
    public final String parserPattern() {
        return PARSER_PATTERN;
    }

    @Override
    public abstract String validatorPattern();

    @Override
    public boolean isOptional(int component) {
        if (component == 1) {
            return true;
        }
        if (component == 2) {
            return true;
        }
        return component == 3;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Account");
        result.add("Location");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "account");
        result.put(3, "location");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("dcmark", 1);
        this.labelMap.put("account", 2);
        this.labelMap.put("location", 3);
        return this.labelMap;
    }

    @Override
    public abstract String getName();

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent(1);
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getAccount() {
        String c = this.getComponent(2);
        if (c != null) {
            for (int i = 0; i < c.length(); ++i) {
                if (c.charAt(i) == '/') continue;
                return c.substring(i);
            }
            return "";
        }
        return null;
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getLocation() {
        return this.getComponent(3);
    }

    @Override
    public String getPartyIdentifier() {
        return PartyIdentifierUtils.getPartyIdentifier(this, 1, 2);
    }

    @Override
    public OptionBPartyField setPartyIdentifier(String partyIdentifier) {
        return (OptionBPartyField)PartyIdentifierUtils.setPartyIdentifier(this, 1, 2, partyIdentifier);
    }
}

