/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field23E
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "23E";
    public static final String F_23E = "23E";
    public static final Integer INSTRUCTION_CODE = 1;
    public static final Integer TYPE = 1;
    public static final Integer ADDITIONAL_INFORMATION = 2;
    public static final Integer NARRATIVE = 2;

    public Field23E() {
        super(2);
    }

    public Field23E(String value) {
        super(value);
    }

    public Field23E(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"23E")) {
            throw new IllegalArgumentException("cannot create field 23E from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field23E newInstance(Field23E source) {
        Field23E cp = new Field23E();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("23E", value);
    }

    public static Tag emptyTag() {
        return new Tag("23E", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        if (this.getComponent2() != null) {
            result.append("/").append(this.getComponent2());
        }
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 23E");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "SS";
    }

    @Override
    public String parserPattern() {
        return "S[/S]";
    }

    @Override
    public String validatorPattern() {
        return "4!c[/30x]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Instruction Code");
        result.add("Additional Information");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "instructionCode");
        result.put(2, "additionalInformation");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("instructioncode", 1);
        this.labelMap.put("type", 1);
        this.labelMap.put("code", 1);
        this.labelMap.put("additionalinformation", 2);
        this.labelMap.put("narrative", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getInstructionCode() {
        return this.getComponent1();
    }

    public String getType() {
        return this.getInstructionCode();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getAdditionalInformation() {
        return this.getComponent2();
    }

    public String getNarrative() {
        return this.getAdditionalInformation();
    }

    public Field23E setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field23E setInstructionCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field23E setType(String component1) {
        return this.setInstructionCode(component1);
    }

    public Field23E setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field23E setAdditionalInformation(String component2) {
        return this.setComponent2(component2);
    }

    public Field23E setNarrative(String component2) {
        return this.setAdditionalInformation(component2);
    }

    @Override
    public String getName() {
        return "23E";
    }

    public static Field23E get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("23E");
        if (t == null) {
            return null;
        }
        return new Field23E(t);
    }

    public static Field23E get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field23E.get(msg.getBlock4());
    }

    public static List<Field23E> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field23E.getAll(msg.getBlock4());
    }

    public static List<Field23E> getAll(SwiftTagListBlock block) {
        ArrayList<Field23E> result = new ArrayList<Field23E>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("23E");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field23E(f));
            }
        }
        return result;
    }

    public static Field23E fromJson(String json) {
        Field23E field = new Field23E();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("type") != null) {
            field.setComponent1(jsonObject.get("type").getAsString());
        }
        if (jsonObject.get("code") != null) {
            field.setComponent1(jsonObject.get("code").getAsString());
        }
        if (jsonObject.get("instructionCode") != null) {
            field.setComponent1(jsonObject.get("instructionCode").getAsString());
        }
        if (jsonObject.get("narrative") != null) {
            field.setComponent2(jsonObject.get("narrative").getAsString());
        }
        if (jsonObject.get("additionalInformation") != null) {
            field.setComponent2(jsonObject.get("additionalInformation").getAsString());
        }
        return field;
    }
}

