/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field35H
extends Field
implements Serializable,
AmountContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "35H";
    public static final String F_35H = "35H";
    public static final Integer SIGN = 1;
    public static final Integer CURRENCY = 2;
    public static final Integer QUANTITY = 3;

    public Field35H() {
        super(3);
    }

    public Field35H(String value) {
        super(value);
    }

    public Field35H(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"35H")) {
            throw new IllegalArgumentException("cannot create field 35H from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field35H newInstance(Field35H source) {
        Field35H cp = new Field35H();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("35H", value);
    }

    public static Tag emptyTag() {
        return new Tag("35H", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        String prefix = SwiftParseUtils.getAlphaPrefix(value);
        if (prefix != null) {
            if (prefix.length() > 3) {
                this.setComponent1(StringUtils.substring((String)prefix, (int)0, (int)1));
                this.setComponent2(StringUtils.substring((String)prefix, (int)1, (int)prefix.length()));
            } else {
                this.setComponent2(prefix);
            }
        }
        this.setComponent3(SwiftParseUtils.getNumericSuffix(value));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 35H");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        NumberFormat f = NumberFormat.getNumberInstance(this.notNull(locale));
        f.setMaximumFractionDigits(13);
        BigDecimal n = this.getComponent3AsBigDecimal();
        if (n != null) {
            return f.format(n);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SSI";
    }

    @Override
    public String parserPattern() {
        return "[c]<CUR>N";
    }

    @Override
    public String validatorPattern() {
        return "[<N>]3!a<AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 1;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Sign");
        result.add("Currency");
        result.add("Quantity");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "sign");
        result.put(2, "currency");
        result.put(3, "quantity");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("sign", 1);
        this.labelMap.put("currency", 2);
        this.labelMap.put("quantity", 3);
        this.labelMap.put("amount", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getSign() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getCurrency() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public BigDecimal getComponent3AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(3));
    }

    public String getQuantity() {
        return this.getComponent3();
    }

    public BigDecimal getQuantityAsBigDecimal() {
        return this.getComponent3AsBigDecimal();
    }

    public Field35H setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field35H setSign(String component1) {
        return this.setComponent1(component1);
    }

    public Field35H setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field35H setCurrency(String component2) {
        return this.setComponent2(component2);
    }

    public Field35H setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field35H setComponent3(Number component3) {
        if (component3 instanceof BigDecimal) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal((BigDecimal)component3));
        } else if (component3 instanceof BigInteger) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component3)));
        } else if (component3 instanceof Long || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.longValue())));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component3.doubleValue())));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field35H setQuantity(String component3) {
        return this.setComponent3(component3);
    }

    public Field35H setQuantity(Number component3) {
        return this.setComponent3(component3);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public String getName() {
        return "35H";
    }

    public static Field35H get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("35H");
        if (t == null) {
            return null;
        }
        return new Field35H(t);
    }

    public static Field35H get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field35H.get(msg.getBlock4());
    }

    public static List<Field35H> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field35H.getAll(msg.getBlock4());
    }

    public static List<Field35H> getAll(SwiftTagListBlock block) {
        ArrayList<Field35H> result = new ArrayList<Field35H>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("35H");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field35H(f));
            }
        }
        return result;
    }

    public static Field35H fromJson(String json) {
        Field35H field = new Field35H();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("sign") != null) {
            field.setComponent1(jsonObject.get("sign").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent2(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent3(jsonObject.get("amount").getAsString());
        }
        if (jsonObject.get("quantity") != null) {
            field.setComponent3(jsonObject.get("quantity").getAsString());
        }
        return field;
    }
}

