/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.AmountContainer;
import com.prowidesoftware.swift.model.field.AmountResolver;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field62M
extends Field
implements Serializable,
AmountContainer,
DateContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "62M";
    public static final String F_62M = "62M";
    public static final Integer DC_MARK = 1;
    public static final Integer DATE = 2;
    public static final Integer CURRENCY = 3;
    public static final Integer UNIT = 3;
    public static final Integer AMOUNT = 4;

    public Field62M() {
        super(4);
    }

    public Field62M(String value) {
        super(value);
    }

    public Field62M(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"62M")) {
            throw new IllegalArgumentException("cannot create field 62M from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field62M newInstance(Field62M source) {
        Field62M cp = new Field62M();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("62M", value);
    }

    public static Tag emptyTag() {
        return new Tag("62M", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        this.setComponent1(SwiftParseUtils.getAlphaPrefix(value));
        String toparse = SwiftParseUtils.getNumericSuffix(value);
        this.setComponent2(SwiftParseUtils.getNumericPrefix(toparse));
        String toparse2 = SwiftParseUtils.getAlphaSuffix(toparse);
        this.setComponent3(SwiftParseUtils.getAlphaPrefix(toparse2));
        this.setComponent4(SwiftParseUtils.getNumericSuffix(toparse2));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Format f;
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 62M");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return ((DateFormat)f).format(cal.getTime());
            }
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        f = NumberFormat.getNumberInstance(this.notNull(locale));
        ((NumberFormat)f).setMaximumFractionDigits(13);
        BigDecimal n = this.getComponent4AsBigDecimal();
        if (n != null) {
            return f.format(n);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "SESI";
    }

    @Override
    public String parserPattern() {
        return "c<DATE2>SN";
    }

    @Override
    public String validatorPattern() {
        return "<DC><DATE2><3!a><AMOUNT>15";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("D/C Mark");
        result.add("Date");
        result.add("Currency");
        result.add("Amount");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "dCMark");
        result.put(2, "date");
        result.put(3, "currency");
        result.put(4, "amount");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("dcmark", 1);
        this.labelMap.put("date", 2);
        this.labelMap.put("currency", 3);
        this.labelMap.put("unit", 3);
        this.labelMap.put("amount", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getDCMark() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(2));
    }

    public String getDate() {
        return this.getComponent2();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getCurrency() {
        return this.getComponent3();
    }

    public String getUnit() {
        return this.getCurrency();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public BigDecimal getComponent4AsBigDecimal() {
        return SwiftFormatUtils.getBigDecimal(this.getComponent(4));
    }

    public String getAmount() {
        return this.getComponent4();
    }

    public BigDecimal getAmountAsBigDecimal() {
        return this.getComponent4AsBigDecimal();
    }

    public Field62M setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field62M setDCMark(String component1) {
        return this.setComponent1(component1);
    }

    public Field62M setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field62M setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getDate2(component2));
        return this;
    }

    public Field62M setDate(String component2) {
        return this.setComponent2(component2);
    }

    public Field62M setDate(Calendar component2) {
        return this.setComponent2(component2);
    }

    public Field62M setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field62M setCurrency(String component3) {
        return this.setComponent3(component3);
    }

    public Field62M setUnit(String component3) {
        return this.setCurrency(component3);
    }

    public Field62M setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field62M setComponent4(Number component4) {
        if (component4 instanceof BigDecimal) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal((BigDecimal)component4));
        } else if (component4 instanceof BigInteger) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(new BigDecimal((BigInteger)component4)));
        } else if (component4 instanceof Long || component4 instanceof Integer) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.longValue())));
        } else if (component4 != null) {
            this.setComponent(4, SwiftFormatUtils.getBigDecimal(BigDecimal.valueOf(component4.doubleValue())));
        } else {
            this.setComponent(4, null);
        }
        return this;
    }

    public Field62M setAmount(String component4) {
        return this.setComponent4(component4);
    }

    public Field62M setAmount(Number component4) {
        return this.setComponent4(component4);
    }

    public List<BigDecimal> amounts() {
        return AmountResolver.amounts(this);
    }

    @Override
    public BigDecimal amount() {
        return AmountResolver.amount(this);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "62M";
    }

    public static Field62M get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("62M");
        if (t == null) {
            return null;
        }
        return new Field62M(t);
    }

    public static Field62M get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field62M.get(msg.getBlock4());
    }

    public static List<Field62M> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field62M.getAll(msg.getBlock4());
    }

    public static List<Field62M> getAll(SwiftTagListBlock block) {
        ArrayList<Field62M> result = new ArrayList<Field62M>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("62M");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field62M(f));
            }
        }
        return result;
    }

    public static Field62M fromJson(String json) {
        Field62M field = new Field62M();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("dCMark") != null) {
            field.setComponent1(jsonObject.get("dCMark").getAsString());
        }
        if (jsonObject.get("date") != null) {
            field.setComponent2(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("unit") != null) {
            field.setComponent3(jsonObject.get("unit").getAsString());
        }
        if (jsonObject.get("currency") != null) {
            field.setComponent3(jsonObject.get("currency").getAsString());
        }
        if (jsonObject.get("amount") != null) {
            field.setComponent4(jsonObject.get("amount").getAsString());
        }
        return field;
    }
}

