/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt6xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field20;
import com.prowidesoftware.swift.model.field.Field21;
import com.prowidesoftware.swift.model.field.Field23;
import com.prowidesoftware.swift.model.field.Field25;
import com.prowidesoftware.swift.model.field.Field26C;
import com.prowidesoftware.swift.model.field.Field26D;
import com.prowidesoftware.swift.model.field.Field30;
import com.prowidesoftware.swift.model.field.Field32F;
import com.prowidesoftware.swift.model.field.Field72;
import com.prowidesoftware.swift.model.field.Field82A;
import com.prowidesoftware.swift.model.field.Field82B;
import com.prowidesoftware.swift.model.field.Field82D;
import com.prowidesoftware.swift.model.field.Field86A;
import com.prowidesoftware.swift.model.field.Field86B;
import com.prowidesoftware.swift.model.field.Field86D;
import com.prowidesoftware.swift.model.field.Field87A;
import com.prowidesoftware.swift.model.field.Field87B;
import com.prowidesoftware.swift.model.field.Field87D;
import com.prowidesoftware.swift.model.field.Field88A;
import com.prowidesoftware.swift.model.field.Field88B;
import com.prowidesoftware.swift.model.field.Field88D;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT604
extends AbstractMT
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT604.class.getName());
    public static final String NAME = "604";

    public MT604(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT604(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT604 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT604(m);
    }

    public MT604() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT604(String sender, String receiver) {
        super(604, sender, receiver);
    }

    public MT604(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT604.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT604 object from FIN content with a Service Message. Check if the MT604 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT604 object from FIN content with message type " + param.getType());
        }
    }

    public static MT604 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT604(fin);
    }

    public MT604(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT604 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT604(stream);
    }

    public MT604(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT604 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT604(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT604 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT604 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT604 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT604 fromJson(String json) {
        return (MT604)AbstractMT.fromJson(json);
    }

    public Field26C getField26C() {
        Tag t = this.tag("26C");
        if (t != null) {
            return new Field26C(t.getValue());
        }
        return null;
    }

    public Field25 getField25() {
        Tag t = this.tag("25");
        if (t != null) {
            return new Field25(t.getValue());
        }
        return null;
    }

    public Field30 getField30() {
        Tag t = this.tag("30");
        if (t != null) {
            return new Field30(t.getValue());
        }
        return null;
    }

    public List<Field20> getField20() {
        ArrayList<Field20> result = new ArrayList<Field20>();
        Tag[] tags = this.tags("20");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field21> getField21() {
        ArrayList<Field21> result = new ArrayList<Field21>();
        Tag[] tags = this.tags("21");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field21(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field23> getField23() {
        ArrayList<Field23> result = new ArrayList<Field23>();
        Tag[] tags = this.tags("23");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field23(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field26D> getField26D() {
        ArrayList<Field26D> result = new ArrayList<Field26D>();
        Tag[] tags = this.tags("26D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field26D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field32F> getField32F() {
        ArrayList<Field32F> result = new ArrayList<Field32F>();
        Tag[] tags = this.tags("32F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field32F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field82A> getField82A() {
        ArrayList<Field82A> result = new ArrayList<Field82A>();
        Tag[] tags = this.tags("82A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field82A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field82B> getField82B() {
        ArrayList<Field82B> result = new ArrayList<Field82B>();
        Tag[] tags = this.tags("82B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field82B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field82D> getField82D() {
        ArrayList<Field82D> result = new ArrayList<Field82D>();
        Tag[] tags = this.tags("82D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field82D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field86A> getField86A() {
        ArrayList<Field86A> result = new ArrayList<Field86A>();
        Tag[] tags = this.tags("86A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field86A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field86B> getField86B() {
        ArrayList<Field86B> result = new ArrayList<Field86B>();
        Tag[] tags = this.tags("86B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field86B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field86D> getField86D() {
        ArrayList<Field86D> result = new ArrayList<Field86D>();
        Tag[] tags = this.tags("86D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field86D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field87A> getField87A() {
        ArrayList<Field87A> result = new ArrayList<Field87A>();
        Tag[] tags = this.tags("87A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field87A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field87B> getField87B() {
        ArrayList<Field87B> result = new ArrayList<Field87B>();
        Tag[] tags = this.tags("87B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field87B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field87D> getField87D() {
        ArrayList<Field87D> result = new ArrayList<Field87D>();
        Tag[] tags = this.tags("87D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field87D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field88A> getField88A() {
        ArrayList<Field88A> result = new ArrayList<Field88A>();
        Tag[] tags = this.tags("88A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field88A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field88B> getField88B() {
        ArrayList<Field88B> result = new ArrayList<Field88B>();
        Tag[] tags = this.tags("88B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field88B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field88D> getField88D() {
        ArrayList<Field88D> result = new ArrayList<Field88D>();
        Tag[] tags = this.tags("88D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field88D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field72> getField72() {
        ArrayList<Field72> result = new ArrayList<Field72>();
        Tag[] tags = this.tags("72");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field72(tag.getValue()));
            }
        }
        return result;
    }

    public List<Loop1> getLoop1List() {
        return MT604.getLoop1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public static List<Loop1> getLoop1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocksDelimitedWithOptionalTail(Loop1.START, Loop1.END, Loop1.TAIL)) != null && !blocks.isEmpty()) {
            ArrayList<Loop1> result = new ArrayList<Loop1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                result.add(new Loop1(b));
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static class Loop1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String[] START = new String[]{"20"};
        protected static final String[] END = new String[]{"88A", "88B", "88D"};
        protected static final String[] TAIL = new String[]{"72"};

        private Loop1() {
            super(new ArrayList<Tag>());
        }

        private Loop1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static Loop1 newInstance(Tag ... tags) {
            return Loop1.newInstance(0, 0, tags);
        }

        public static Loop1 newInstance(int start, int end, Tag ... tags) {
            Loop1 result = new Loop1();
            result.append(new Tag(START[start], ""));
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(new Tag(END[end], ""));
            return result;
        }
    }
}

