/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import com.prowidesoftware.swift.utils.UnicodeEscaper;

class JavaUnicodeEscaper
extends UnicodeEscaper {
    static JavaUnicodeEscaper above(int codePoint) {
        return JavaUnicodeEscaper.outsideOf(0, codePoint);
    }

    static JavaUnicodeEscaper below(int codePoint) {
        return JavaUnicodeEscaper.outsideOf(codePoint, Integer.MAX_VALUE);
    }

    static JavaUnicodeEscaper between(int codePointLow, int codePointHigh) {
        return new JavaUnicodeEscaper(codePointLow, codePointHigh, true);
    }

    static JavaUnicodeEscaper outsideOf(int codePointLow, int codePointHigh) {
        return new JavaUnicodeEscaper(codePointLow, codePointHigh, false);
    }

    JavaUnicodeEscaper(int below, int above, boolean between) {
        super(below, above, between);
    }

    @Override
    protected String toUtf16Escape(int codePoint) {
        char[] surrogatePair = Character.toChars(codePoint);
        return "\\u" + JavaUnicodeEscaper.hex(surrogatePair[0]) + "\\u" + JavaUnicodeEscaper.hex(surrogatePair[1]);
    }
}

