/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field31P
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "31P";
    public static final String F_31P = "31P";
    public static final Integer DATE = 1;
    public static final Integer PLACE = 2;

    public Field31P() {
        super(2);
    }

    public Field31P(String value) {
        super(value);
    }

    public Field31P(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"31P")) {
            throw new IllegalArgumentException("cannot create field 31P from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field31P newInstance(Field31P source) {
        Field31P cp = new Field31P();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("31P", value);
    }

    public static Tag emptyTag() {
        return new Tag("31P", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            if (value.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
            }
            if (value.length() > 6) {
                this.setComponent2(StringUtils.substring((String)value, (int)6));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 31P");
        }
        if (component == 1) {
            DateFormat f = DateFormat.getDateInstance(2, this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return this.getComponent(2);
    }

    @Override
    public String typesPattern() {
        return "ES";
    }

    @Override
    public String parserPattern() {
        return "<DATE2>[S]";
    }

    @Override
    public String validatorPattern() {
        return "<DATE2>[29x]";
    }

    @Override
    public boolean isOptional(int component) {
        return component == 2;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Place");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "place");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("place", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate2(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getPlace() {
        return this.getComponent2();
    }

    public Field31P setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field31P setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate2(component1));
        return this;
    }

    public Field31P setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field31P setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field31P setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field31P setPlace(String component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "31P";
    }

    public static Field31P get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("31P");
        if (t == null) {
            return null;
        }
        return new Field31P(t);
    }

    public static Field31P get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field31P.get(msg.getBlock4());
    }

    public static List<Field31P> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field31P.getAll(msg.getBlock4());
    }

    public static List<Field31P> getAll(SwiftTagListBlock block) {
        ArrayList<Field31P> result = new ArrayList<Field31P>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("31P");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field31P(f));
            }
        }
        return result;
    }

    public static Field31P fromJson(String json) {
        Field31P field = new Field31P();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("place") != null) {
            field.setComponent2(jsonObject.get("place").getAsString());
        }
        return field;
    }
}

