/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field336
extends Field
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "336";
    public static final String F_336 = "336";
    public static final Integer DELIVERY_SUBSET_NAME = 1;
    public static final Integer NUMBER_OF_MESSAGES = 2;
    public static final Integer CODES = 3;

    public Field336() {
        super(3);
    }

    public Field336(String value) {
        super(value);
    }

    public Field336(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"336")) {
            throw new IllegalArgumentException("cannot create field 336 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field336 newInstance(Field336 source) {
        Field336 cp = new Field336();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("336", value);
    }

    public static Tag emptyTag() {
        return new Tag("336", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        if (value != null) {
            if (value.length() >= 6) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)6));
            }
            if (value.length() >= 11) {
                this.setComponent2(StringUtils.substring((String)value, (int)6, (int)11));
            }
            if (value.length() > 11) {
                this.setComponent3(StringUtils.substring((String)value, (int)11));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 336");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        return this.getComponent(3);
    }

    @Override
    public String typesPattern() {
        return "SNS";
    }

    @Override
    public String parserPattern() {
        return "6!S5!NS";
    }

    @Override
    public String validatorPattern() {
        return "6!c5!n[36c]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Delivery Subset Name");
        result.add("Number Of Messages");
        result.add("Codes");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "deliverySubsetName");
        result.put(2, "numberOfMessages");
        result.put(3, "codes");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("deliverysubsetname", 1);
        this.labelMap.put("numberofmessages", 2);
        this.labelMap.put("codes", 3);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public String getDeliverySubsetName() {
        return this.getComponent1();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Long getComponent2AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(2));
    }

    public String getNumberOfMessages() {
        return this.getComponent2();
    }

    public Long getNumberOfMessagesAsLong() {
        return this.getComponent2AsLong();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public String getCodes() {
        return this.getComponent3();
    }

    public Field336 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field336 setDeliverySubsetName(String component1) {
        return this.setComponent1(component1);
    }

    public Field336 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field336 setComponent2(Number component2) {
        if (component2 instanceof Long) {
            this.setComponent(2, SwiftFormatUtils.getLong((Long)component2));
        } else if (component2 instanceof BigInteger || component2 instanceof Integer) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else if (component2 != null) {
            this.setComponent(2, SwiftFormatUtils.getLong(component2.longValue()));
        } else {
            this.setComponent(2, null);
        }
        return this;
    }

    public Field336 setNumberOfMessages(String component2) {
        return this.setComponent2(component2);
    }

    public Field336 setNumberOfMessages(Number component2) {
        return this.setComponent2(component2);
    }

    public Field336 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field336 setCodes(String component3) {
        return this.setComponent3(component3);
    }

    @Override
    public String getName() {
        return "336";
    }

    public static Field336 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("336");
        if (t == null) {
            return null;
        }
        return new Field336(t);
    }

    public static Field336 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field336.get(msg.getBlock4());
    }

    public static List<Field336> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field336.getAll(msg.getBlock4());
    }

    public static List<Field336> getAll(SwiftTagListBlock block) {
        ArrayList<Field336> result = new ArrayList<Field336>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("336");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field336(f));
            }
        }
        return result;
    }

    public static Field336 fromJson(String json) {
        Field336 field = new Field336();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("deliverySubsetName") != null) {
            field.setComponent1(jsonObject.get("deliverySubsetName").getAsString());
        }
        if (jsonObject.get("numberOfMessages") != null) {
            field.setComponent2(jsonObject.get("numberOfMessages").getAsString());
        }
        if (jsonObject.get("codes") != null) {
            field.setComponent3(jsonObject.get("codes").getAsString());
        }
        return field;
    }
}

