/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt;

import com.prowidesoftware.swift.model.AbstractMessage;
import com.prowidesoftware.swift.model.BIC;
import com.prowidesoftware.swift.model.MessageMetadataStrategy;
import com.prowidesoftware.swift.model.Money;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessageUtils;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import java.util.Calendar;
import java.util.Optional;

public class DefaultMtMetadataStrategy
implements MessageMetadataStrategy {
    @Override
    public Optional<String> reference(AbstractMessage message) {
        return Optional.ofNullable(SwiftMessageUtils.reference(this.asSwiftMessage(message)));
    }

    @Override
    public Optional<Money> amount(AbstractMessage message) {
        return Optional.ofNullable(SwiftMessageUtils.money(this.asSwiftMessage(message)));
    }

    @Override
    public Optional<Calendar> valueDate(AbstractMessage message) {
        return Optional.ofNullable(SwiftMessageUtils.valueDate(this.asSwiftMessage(message)));
    }

    @Override
    public Optional<Calendar> tradeDate(AbstractMessage message) {
        return Optional.ofNullable(SwiftMessageUtils.tradeDate(this.asSwiftMessage(message)));
    }

    @Override
    public Optional<String> sender(AbstractMessage message) {
        String sender = SwiftMessageUtils.sender(this.asSwiftMessage(message));
        if (sender != null) {
            return Optional.of(new BIC(sender).getBic11());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> receiver(AbstractMessage message) {
        String receiver = SwiftMessageUtils.receiver(this.asSwiftMessage(message));
        if (receiver != null) {
            return Optional.of(new BIC(receiver).getBic11());
        }
        return Optional.empty();
    }

    @Override
    public Optional<String> identifier(AbstractMessage message) {
        return Optional.ofNullable(SwiftMessageUtils.identifier(this.asSwiftMessage(message)));
    }

    private SwiftMessage asSwiftMessage(AbstractMessage message) {
        if (message != null && message.isMT()) {
            AbstractMT mt = (AbstractMT)message;
            return mt.getSwiftMessage();
        }
        return null;
    }
}

