/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.mt.mt5xx;

import com.prowidesoftware.swift.model.MtSwiftMessage;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.Field11A;
import com.prowidesoftware.swift.model.field.Field12A;
import com.prowidesoftware.swift.model.field.Field12C;
import com.prowidesoftware.swift.model.field.Field13A;
import com.prowidesoftware.swift.model.field.Field13B;
import com.prowidesoftware.swift.model.field.Field16R;
import com.prowidesoftware.swift.model.field.Field16S;
import com.prowidesoftware.swift.model.field.Field20C;
import com.prowidesoftware.swift.model.field.Field22F;
import com.prowidesoftware.swift.model.field.Field23G;
import com.prowidesoftware.swift.model.field.Field28E;
import com.prowidesoftware.swift.model.field.Field35B;
import com.prowidesoftware.swift.model.field.Field36B;
import com.prowidesoftware.swift.model.field.Field36D;
import com.prowidesoftware.swift.model.field.Field70E;
import com.prowidesoftware.swift.model.field.Field70F;
import com.prowidesoftware.swift.model.field.Field92A;
import com.prowidesoftware.swift.model.field.Field93B;
import com.prowidesoftware.swift.model.field.Field93C;
import com.prowidesoftware.swift.model.field.Field93E;
import com.prowidesoftware.swift.model.field.Field93F;
import com.prowidesoftware.swift.model.field.Field94B;
import com.prowidesoftware.swift.model.field.Field94C;
import com.prowidesoftware.swift.model.field.Field94F;
import com.prowidesoftware.swift.model.field.Field95P;
import com.prowidesoftware.swift.model.field.Field95Q;
import com.prowidesoftware.swift.model.field.Field95R;
import com.prowidesoftware.swift.model.field.Field97A;
import com.prowidesoftware.swift.model.field.Field97C;
import com.prowidesoftware.swift.model.field.Field97D;
import com.prowidesoftware.swift.model.field.Field98A;
import com.prowidesoftware.swift.model.field.Field98C;
import com.prowidesoftware.swift.model.field.Field98E;
import com.prowidesoftware.swift.model.mt.AbstractMT;
import com.prowidesoftware.swift.utils.Lib;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class MT568
extends AbstractMT
implements Serializable {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(MT568.class.getName());
    public static final String NAME = "568";

    public MT568(SwiftMessage m) {
        super(m);
        this.sanityCheck(m);
    }

    public MT568(MtSwiftMessage m) {
        this(m.message());
    }

    public static MT568 parse(MtSwiftMessage m) {
        if (m == null) {
            return null;
        }
        return new MT568(m);
    }

    public MT568() {
        this("TESTARZZ", "TESTARZZ");
    }

    public MT568(String sender, String receiver) {
        super(568, sender, receiver);
    }

    public MT568(String fin) {
        SwiftMessage parsed;
        if (fin != null && (parsed = MT568.read(fin)) != null) {
            this.m = parsed;
            this.sanityCheck(parsed);
        }
    }

    private void sanityCheck(SwiftMessage param) {
        if (param.isServiceMessage()) {
            log.warning("Creating an MT568 object from FIN content with a Service Message. Check if the MT568 you are intended to read is prepended with and ACK.");
        } else if (!StringUtils.equals((CharSequence)param.getType(), (CharSequence)NAME)) {
            log.warning("Creating an MT568 object from FIN content with message type " + param.getType());
        }
    }

    public static MT568 parse(String fin) {
        if (fin == null) {
            return null;
        }
        return new MT568(fin);
    }

    public MT568(InputStream stream) throws IOException {
        this(Lib.readStream(stream));
    }

    public static MT568 parse(InputStream stream) throws IOException {
        if (stream == null) {
            return null;
        }
        return new MT568(stream);
    }

    public MT568(File file) throws IOException {
        this(Lib.readFile(file));
    }

    public static MT568 parse(File file) throws IOException {
        if (file == null) {
            return null;
        }
        return new MT568(file);
    }

    @Override
    public String getMessageType() {
        return NAME;
    }

    @Override
    public MT568 append(SwiftTagListBlock block) {
        super.append(block);
        return this;
    }

    @Override
    public MT568 append(Tag ... tags) {
        super.append(tags);
        return this;
    }

    @Override
    public MT568 append(Field ... fields) {
        super.append(fields);
        return this;
    }

    public static MT568 fromJson(String json) {
        return (MT568)AbstractMT.fromJson(json);
    }

    public Field28E getField28E() {
        Tag t = this.tag("28E");
        if (t != null) {
            return new Field28E(t.getValue());
        }
        return null;
    }

    public Field23G getField23G() {
        Tag t = this.tag("23G");
        if (t != null) {
            return new Field23G(t.getValue());
        }
        return null;
    }

    public Field98C getField98C() {
        Tag t = this.tag("98C");
        if (t != null) {
            return new Field98C(t.getValue());
        }
        return null;
    }

    public Field98E getField98E() {
        Tag t = this.tag("98E");
        if (t != null) {
            return new Field98E(t.getValue());
        }
        return null;
    }

    public Field97A getField97A() {
        Tag t = this.tag("97A");
        if (t != null) {
            return new Field97A(t.getValue());
        }
        return null;
    }

    public Field97C getField97C() {
        Tag t = this.tag("97C");
        if (t != null) {
            return new Field97C(t.getValue());
        }
        return null;
    }

    public Field97D getField97D() {
        Tag t = this.tag("97D");
        if (t != null) {
            return new Field97D(t.getValue());
        }
        return null;
    }

    public Field94C getField94C() {
        Tag t = this.tag("94C");
        if (t != null) {
            return new Field94C(t.getValue());
        }
        return null;
    }

    public Field94F getField94F() {
        Tag t = this.tag("94F");
        if (t != null) {
            return new Field94F(t.getValue());
        }
        return null;
    }

    public Field35B getField35B() {
        Tag t = this.tag("35B");
        if (t != null) {
            return new Field35B(t.getValue());
        }
        return null;
    }

    public Field12A getField12A() {
        Tag t = this.tag("12A");
        if (t != null) {
            return new Field12A(t.getValue());
        }
        return null;
    }

    public Field12C getField12C() {
        Tag t = this.tag("12C");
        if (t != null) {
            return new Field12C(t.getValue());
        }
        return null;
    }

    public Field11A getField11A() {
        Tag t = this.tag("11A");
        if (t != null) {
            return new Field11A(t.getValue());
        }
        return null;
    }

    public List<Field20C> getField20C() {
        ArrayList<Field20C> result = new ArrayList<Field20C>();
        Tag[] tags = this.tags("20C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field20C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16R> getField16R() {
        ArrayList<Field16R> result = new ArrayList<Field16R>();
        Tag[] tags = this.tags("16R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16R(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field22F> getField22F() {
        ArrayList<Field22F> result = new ArrayList<Field22F>();
        Tag[] tags = this.tags("22F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field22F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13A> getField13A() {
        ArrayList<Field13A> result = new ArrayList<Field13A>();
        Tag[] tags = this.tags("13A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field13B> getField13B() {
        ArrayList<Field13B> result = new ArrayList<Field13B>();
        Tag[] tags = this.tags("13B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field13B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field16S> getField16S() {
        ArrayList<Field16S> result = new ArrayList<Field16S>();
        Tag[] tags = this.tags("16S");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field16S(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field94B> getField94B() {
        ArrayList<Field94B> result = new ArrayList<Field94B>();
        Tag[] tags = this.tags("94B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field94B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field98A> getField98A() {
        ArrayList<Field98A> result = new ArrayList<Field98A>();
        Tag[] tags = this.tags("98A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field98A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field92A> getField92A() {
        ArrayList<Field92A> result = new ArrayList<Field92A>();
        Tag[] tags = this.tags("92A");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field92A(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field36B> getField36B() {
        ArrayList<Field36B> result = new ArrayList<Field36B>();
        Tag[] tags = this.tags("36B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field36B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field36D> getField36D() {
        ArrayList<Field36D> result = new ArrayList<Field36D>();
        Tag[] tags = this.tags("36D");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field36D(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field93B> getField93B() {
        ArrayList<Field93B> result = new ArrayList<Field93B>();
        Tag[] tags = this.tags("93B");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field93B(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field93C> getField93C() {
        ArrayList<Field93C> result = new ArrayList<Field93C>();
        Tag[] tags = this.tags("93C");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field93C(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field93E> getField93E() {
        ArrayList<Field93E> result = new ArrayList<Field93E>();
        Tag[] tags = this.tags("93E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field93E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field93F> getField93F() {
        ArrayList<Field93F> result = new ArrayList<Field93F>();
        Tag[] tags = this.tags("93F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field93F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70E> getField70E() {
        ArrayList<Field70E> result = new ArrayList<Field70E>();
        Tag[] tags = this.tags("70E");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70E(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field70F> getField70F() {
        ArrayList<Field70F> result = new ArrayList<Field70F>();
        Tag[] tags = this.tags("70F");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field70F(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95P> getField95P() {
        ArrayList<Field95P> result = new ArrayList<Field95P>();
        Tag[] tags = this.tags("95P");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95P(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95Q> getField95Q() {
        ArrayList<Field95Q> result = new ArrayList<Field95Q>();
        Tag[] tags = this.tags("95Q");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95Q(tag.getValue()));
            }
        }
        return result;
    }

    public List<Field95R> getField95R() {
        ArrayList<Field95R> result = new ArrayList<Field95R>();
        Tag[] tags = this.tags("95R");
        if (tags != null && tags.length > 0) {
            for (Tag tag : tags) {
                result.add(new Field95R(tag.getValue()));
            }
        }
        return result;
    }

    public SequenceA getSequenceA() {
        return new SequenceA(super.getSwiftMessageNotNullOrException());
    }

    public SequenceA getSequenceGENL() {
        return this.getSequenceA();
    }

    public static SequenceA getSequenceA(SwiftTagListBlock parentSequence) {
        SequenceA s = new SequenceA();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("GENL").getTags());
        }
        return s;
    }

    public static SequenceA getSequenceGENL(SwiftTagListBlock parentSequence) {
        return MT568.getSequenceA(parentSequence);
    }

    public List<SequenceA1> getSequenceA1List() {
        return MT568.getSequenceA1List(super.getSwiftMessageNotNullOrException().getBlock4());
    }

    public List<SequenceA1> getSequenceLINKList() {
        return this.getSequenceA1List();
    }

    public static List<SequenceA1> getSequenceA1List(SwiftTagListBlock parentSequence) {
        List<SwiftTagListBlock> blocks;
        if (parentSequence != null && (blocks = parentSequence.getSubBlocks("LINK")) != null && !blocks.isEmpty()) {
            ArrayList<SequenceA1> result = new ArrayList<SequenceA1>(blocks.size());
            for (SwiftTagListBlock b : blocks) {
                SequenceA1 s = new SequenceA1();
                s.setTags(b.getSubBlock("LINK").getTags());
                result.add(s);
            }
            return result;
        }
        return Collections.emptyList();
    }

    public static List<SequenceA1> getSequenceLINKList(SwiftTagListBlock parentSequence) {
        return MT568.getSequenceA1List(parentSequence);
    }

    public SequenceB getSequenceB() {
        return new SequenceB(super.getSwiftMessageNotNullOrException());
    }

    public SequenceB getSequenceUSECU() {
        return this.getSequenceB();
    }

    public static SequenceB getSequenceB(SwiftTagListBlock parentSequence) {
        SequenceB s = new SequenceB();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("USECU").getTags());
        }
        return s;
    }

    public static SequenceB getSequenceUSECU(SwiftTagListBlock parentSequence) {
        return MT568.getSequenceB(parentSequence);
    }

    public SequenceB1 getSequenceB1() {
        return new SequenceB1(super.getSwiftMessageNotNullOrException());
    }

    public SequenceB1 getSequenceFIA() {
        return this.getSequenceB1();
    }

    public static SequenceB1 getSequenceB1(SwiftTagListBlock parentSequence) {
        SequenceB1 s = new SequenceB1();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("FIA").getTags());
        }
        return s;
    }

    public static SequenceB1 getSequenceFIA(SwiftTagListBlock parentSequence) {
        return MT568.getSequenceB1(parentSequence);
    }

    public SequenceC getSequenceC() {
        return new SequenceC(super.getSwiftMessageNotNullOrException());
    }

    public SequenceC getSequenceADDINFO() {
        return this.getSequenceC();
    }

    public static SequenceC getSequenceC(SwiftTagListBlock parentSequence) {
        SequenceC s = new SequenceC();
        if (parentSequence != null) {
            s.setTags(parentSequence.getSubBlock("ADDINFO").getTags());
        }
        return s;
    }

    public static SequenceC getSequenceADDINFO(SwiftTagListBlock parentSequence) {
        return MT568.getSequenceC(parentSequence);
    }

    public static class SequenceC
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "ADDINFO";
        public static final Tag START_TAG = new Tag("16R", "ADDINFO");
        public static final Tag END_TAG = new Tag("16S", "ADDINFO");

        private SequenceC() {
            super(new ArrayList<Tag>());
        }

        private SequenceC(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceC newInstance(Tag ... tags) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance() {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceC newInstance(SwiftTagListBlock ... sequences) {
            SequenceC result = new SequenceC();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceC(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "FIA";
        public static final Tag START_TAG = new Tag("16R", "FIA");
        public static final Tag END_TAG = new Tag("16S", "FIA");

        private SequenceB1() {
            super(new ArrayList<Tag>());
        }

        private SequenceB1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB1 newInstance(Tag ... tags) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance() {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceB1 result = new SequenceB1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceB
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "USECU";
        public static final Tag START_TAG = new Tag("16R", "USECU");
        public static final Tag END_TAG = new Tag("16S", "USECU");

        private SequenceB() {
            super(new ArrayList<Tag>());
        }

        private SequenceB(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceB newInstance(Tag ... tags) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance() {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceB newInstance(SwiftTagListBlock ... sequences) {
            SequenceB result = new SequenceB();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceB(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA1
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "LINK";
        public static final Tag START_TAG = new Tag("16R", "LINK");
        public static final Tag END_TAG = new Tag("16S", "LINK");

        private SequenceA1() {
            super(new ArrayList<Tag>());
        }

        private SequenceA1(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA1 newInstance(Tag ... tags) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance() {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA1 newInstance(SwiftTagListBlock ... sequences) {
            SequenceA1 result = new SequenceA1();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA1(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }

    public static class SequenceA
    extends SwiftTagListBlock {
        private static final long serialVersionUID = 1L;
        public static final String START_END_16RS = "GENL";
        public static final Tag START_TAG = new Tag("16R", "GENL");
        public static final Tag END_TAG = new Tag("16S", "GENL");

        private SequenceA() {
            super(new ArrayList<Tag>());
        }

        private SequenceA(SwiftTagListBlock content) {
            super(content.getTags());
        }

        public static SequenceA newInstance(Tag ... tags) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (tags != null && tags.length > 0) {
                for (Tag t : tags) {
                    result.append(t);
                }
            }
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance() {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            result.append(END_TAG);
            return result;
        }

        public static SequenceA newInstance(SwiftTagListBlock ... sequences) {
            SequenceA result = new SequenceA();
            result.append(START_TAG);
            if (sequences != null && sequences.length > 0) {
                for (SwiftTagListBlock s : sequences) {
                    result.addTags(s.getTags());
                }
            }
            result.append(END_TAG);
            return result;
        }

        private SequenceA(SwiftMessage m) {
            if (m.getBlock4() != null) {
                this.setTags(m.getBlock4().getSubBlock(START_END_16RS).getTags());
            }
        }
    }
}

