/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field13E
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2022;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "13E";
    public static final String F_13E = "13E";
    public static final Integer DATE = 1;
    public static final Integer TIME = 2;

    public Field13E() {
        super(2);
    }

    public Field13E(String value) {
        super(value);
    }

    public Field13E(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"13E")) {
            throw new IllegalArgumentException("cannot create field 13E from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field13E newInstance(Field13E source) {
        Field13E cp = new Field13E();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("13E", value);
    }

    public static Tag emptyTag() {
        return new Tag("13E", "");
    }

    @Override
    public void parse(String value) {
        this.init(2);
        if (value != null) {
            if (value.length() >= 8) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)8));
            }
            if (value.length() >= 12) {
                this.setComponent2(StringUtils.substring((String)value, (int)8, (int)12));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 2) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 13E");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            cal = this.getComponent2AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "DH";
    }

    @Override
    public String parserPattern() {
        return "<DATE4><HHMM>";
    }

    @Override
    public String validatorPattern() {
        return "<DATE4><HHMM>";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 2;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Time");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "time");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("time", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public Calendar getComponent2AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(2));
    }

    public String getTime() {
        return this.getComponent2();
    }

    public Calendar getTimeAsCalendar() {
        return this.getComponent2AsCalendar();
    }

    public Field13E setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field13E setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field13E setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field13E setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field13E setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field13E setComponent2(Calendar component2) {
        this.setComponent(2, SwiftFormatUtils.getTime3(component2));
        return this;
    }

    public Field13E setTime(String component2) {
        return this.setComponent2(component2);
    }

    public Field13E setTime(Calendar component2) {
        return this.setComponent2(component2);
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "13E";
    }

    public static Field13E get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("13E");
        if (t == null) {
            return null;
        }
        return new Field13E(t);
    }

    public static Field13E get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field13E.get(msg.getBlock4());
    }

    public static List<Field13E> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field13E.getAll(msg.getBlock4());
    }

    public static List<Field13E> getAll(SwiftTagListBlock block) {
        ArrayList<Field13E> result = new ArrayList<Field13E>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("13E");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field13E(f));
            }
        }
        return result;
    }

    public static Field13E fromJson(String json) {
        Field13E field = new Field13E();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("time") != null) {
            field.setComponent2(jsonObject.get("time").getAsString());
        }
        return field;
    }
}

