/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.MultiLineField;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field130
extends Field
implements Serializable,
MultiLineField {
    public static final int SRU = 2024;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "130";
    public static final String F_130 = "130";
    public static final Integer HEADING_CODE = 1;
    public static final Integer HEADING_TEXT = 2;
    public static final Integer HEADING_CODE_2 = 3;
    public static final Integer HEADING_TEXT_2 = 4;

    public Field130() {
        super(4);
    }

    public Field130(String value) {
        super(value);
    }

    public Field130(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"130")) {
            throw new IllegalArgumentException("cannot create field 130 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field130 newInstance(Field130 source) {
        Field130 cp = new Field130();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("130", value);
    }

    public static Tag emptyTag() {
        return new Tag("130", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        List<String> lines = SwiftParseUtils.getLines(value);
        if (!lines.isEmpty()) {
            this.setComponent1(SwiftParseUtils.getTokenFirst(lines.get(0), "/", "/"));
            this.setComponent2(SwiftParseUtils.getTokenSecondLast(lines.get(0), "/", "/"));
            if (lines.size() > 1) {
                this.setComponent3(SwiftParseUtils.getTokenFirst(lines.get(1), "/", "/"));
                this.setComponent4(SwiftParseUtils.getTokenSecondLast(lines.get(1), "/", "/"));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append("/");
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        if (this.getComponent3() != null || this.getComponent4() != null) {
            result.append("\r\n");
        }
        result.append("/");
        this.append(result, 3);
        result.append("/");
        this.append(result, 4);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 130");
        }
        if (component == 1) {
            return this.getComponent(1);
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        if (component == 4) {
            return this.getComponent(4);
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "NSNS";
    }

    @Override
    public String parserPattern() {
        return "/S/S$/S/S";
    }

    @Override
    public String validatorPattern() {
        return "/2!n/65x$/2!n/65x";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Heading Code");
        result.add("Heading Text");
        result.add("Heading Code 2");
        result.add("Heading Text 2");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "headingCode");
        result.put(2, "headingText");
        result.put(3, "headingCode2");
        result.put(4, "headingText2");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("headingcode", 1);
        this.labelMap.put("headingtext", 2);
        this.labelMap.put("headingcode2", 3);
        this.labelMap.put("headingtext2", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Long getComponent1AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(1));
    }

    public String getHeadingCode() {
        return this.getComponent1();
    }

    public Long getHeadingCodeAsLong() {
        return this.getComponent1AsLong();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getHeadingText() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Long getComponent3AsLong() {
        return SwiftFormatUtils.getLong(this.getComponent(3));
    }

    public String getHeadingCode2() {
        return this.getComponent3();
    }

    public Long getHeadingCode2AsLong() {
        return this.getComponent3AsLong();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getHeadingText2() {
        return this.getComponent4();
    }

    public Field130 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field130 setComponent1(Long component1) {
        this.setComponent(1, SwiftFormatUtils.getLong(component1));
        return this;
    }

    public Field130 setComponent1(Number component1) {
        if (component1 instanceof Long) {
            this.setComponent(1, SwiftFormatUtils.getLong((Long)component1));
        } else if (component1 instanceof BigInteger || component1 instanceof Integer) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else if (component1 != null) {
            this.setComponent(1, SwiftFormatUtils.getLong(component1.longValue()));
        } else {
            this.setComponent(1, null);
        }
        return this;
    }

    public Field130 setHeadingCode(String component1) {
        return this.setComponent1(component1);
    }

    public Field130 setHeadingCode(Long component1) {
        return this.setComponent1(component1);
    }

    public Field130 setHeadingCode(Number component1) {
        return this.setComponent1(component1);
    }

    public Field130 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field130 setHeadingText(String component2) {
        return this.setComponent2(component2);
    }

    public Field130 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field130 setComponent3(Long component3) {
        this.setComponent(3, SwiftFormatUtils.getLong(component3));
        return this;
    }

    public Field130 setComponent3(Number component3) {
        if (component3 instanceof Long) {
            this.setComponent(3, SwiftFormatUtils.getLong((Long)component3));
        } else if (component3 instanceof BigInteger || component3 instanceof Integer) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else if (component3 != null) {
            this.setComponent(3, SwiftFormatUtils.getLong(component3.longValue()));
        } else {
            this.setComponent(3, null);
        }
        return this;
    }

    public Field130 setHeadingCode2(String component3) {
        return this.setComponent3(component3);
    }

    public Field130 setHeadingCode2(Long component3) {
        return this.setComponent3(component3);
    }

    public Field130 setHeadingCode2(Number component3) {
        return this.setComponent3(component3);
    }

    public Field130 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field130 setHeadingText2(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "130";
    }

    public static Field130 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("130");
        if (t == null) {
            return null;
        }
        return new Field130(t);
    }

    public static Field130 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field130.get(msg.getBlock4());
    }

    public static List<Field130> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field130.getAll(msg.getBlock4());
    }

    public static List<Field130> getAll(SwiftTagListBlock block) {
        ArrayList<Field130> result = new ArrayList<Field130>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("130");
        if (arr != null && arr.length > 0) {
            for (Tag f : arr) {
                result.add(new Field130(f));
            }
        }
        return result;
    }

    @Override
    public String getLine(int line) {
        return this.getLine(line, 0);
    }

    @Override
    public String getLine(int line, int offset) {
        Field130 cp = Field130.newInstance(this);
        return this.getLine(cp, line, null, offset);
    }

    @Override
    public List<String> getLines() {
        return SwiftParseUtils.getLines(this.getValue());
    }

    @Override
    public List<String> getLines(int offset) {
        Field130 cp = Field130.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, null, null, offset));
    }

    @Override
    public List<String> getLinesBetween(int start, int end) {
        return this.getLinesBetween(start, end, 0);
    }

    @Override
    public List<String> getLinesBetween(int start, int end, int offset) {
        Field130 cp = Field130.newInstance(this);
        return SwiftParseUtils.getLines(this.getLine(cp, start, end, offset));
    }

    public static Field130 fromJson(String json) {
        Field130 field = new Field130();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("headingCode") != null) {
            field.setComponent1(jsonObject.get("headingCode").getAsString());
        }
        if (jsonObject.get("headingText") != null) {
            field.setComponent2(jsonObject.get("headingText").getAsString());
        }
        if (jsonObject.get("headingCode2") != null) {
            field.setComponent3(jsonObject.get("headingCode2").getAsString());
        }
        if (jsonObject.get("headingText2") != null) {
            field.setComponent4(jsonObject.get("headingText2").getAsString());
        }
        return field;
    }
}

