/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.utils;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;

class PropertyLoader {
    private static final Logger log = Logger.getLogger(PropertyLoader.class.getName());
    static final String PROPERTIES_FILE = "pw-swift-core.properties";
    private static Properties properties = null;
    private static final ReentrantLock lock = new ReentrantLock();

    private PropertyLoader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties() {
        block19: {
            if (properties == null) {
                lock.lock();
                try {
                    if (properties != null) break block19;
                    Properties tempProperties = new Properties();
                    try (InputStream inputStream = PropertyLoader.class.getClassLoader().getResourceAsStream(PROPERTIES_FILE);){
                        if (inputStream != null) {
                            tempProperties.load(inputStream);
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, "Error loading properties from pw-swift-core.properties", e);
                    }
                    properties = tempProperties;
                }
                finally {
                    lock.unlock();
                }
            }
        }
        return properties;
    }

    static String[] getPropertyArray(String key) {
        Properties loadedProperties = PropertyLoader.loadProperties();
        String propertyValue = loadedProperties.getProperty(key);
        if (propertyValue != null) {
            return propertyValue.split(",");
        }
        return new String[0];
    }

    static String getProperty(String key) {
        Properties loadedProperties = PropertyLoader.loadProperties();
        return loadedProperties.getProperty(key);
    }
}

