/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.MOR;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field281
extends Field
implements Serializable {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "281";
    public static final String F_281 = "281";
    public static final Integer OUTPUT_TIME = 1;
    public static final Integer MOR = 2;
    public static final Integer ACCEPTED = 3;
    public static final Integer ERROR = 4;

    public Field281() {
        super(4);
    }

    public Field281(String value) {
        super(value);
    }

    public Field281(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"281")) {
            throw new IllegalArgumentException("cannot create field 281 from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field281 newInstance(Field281 source) {
        Field281 cp = new Field281();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("281", value);
    }

    public static Tag emptyTag() {
        return new Tag("281", "");
    }

    @Override
    public void parse(String value) {
        this.init(4);
        if (value != null) {
            if (value.length() >= 4) {
                this.setComponent1(StringUtils.substring((String)value, (int)0, (int)4));
            }
            if (value.length() >= 32) {
                this.setComponent2(StringUtils.substring((String)value, (int)4, (int)32));
            }
            if (value.length() >= 33) {
                this.setComponent3(StringUtils.substring((String)value, (int)32, (int)33));
            }
            if (value.length() > 33) {
                this.setComponent4(StringUtils.substring((String)value, (int)33));
            }
        }
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        result.append(this.joinComponents());
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        if (component < 1 || component > 4) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 281");
        }
        if (component == 1) {
            SimpleDateFormat f = new SimpleDateFormat("HH:mm", this.notNull(locale));
            Calendar cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        if (component == 3) {
            return this.getComponent(3);
        }
        return this.getComponent(4);
    }

    @Override
    public String typesPattern() {
        return "HVLS";
    }

    @Override
    public String parserPattern() {
        return "<HHMM><MOR>cS";
    }

    @Override
    public String validatorPattern() {
        return "<HHMM><MOR>1!a[3!c]";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 4;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Output Time");
        result.add("MOR");
        result.add("Accepted");
        result.add("Error");
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "outputTime");
        result.put(2, "mOR");
        result.put(3, "accepted");
        result.put(4, "error");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("outputtime", 1);
        this.labelMap.put("mor", 2);
        this.labelMap.put("accepted", 3);
        this.labelMap.put("error", 4);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(1));
    }

    public String getOutputTime() {
        return this.getComponent1();
    }

    public Calendar getOutputTimeAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public MOR getComponent2AsMOR() {
        return SwiftFormatUtils.getMOR(this.getComponent(2));
    }

    public String getMOR() {
        return this.getComponent2();
    }

    public MOR getMORAsMOR() {
        return this.getComponent2AsMOR();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Boolean getComponent3AsBoolean() {
        return SwiftFormatUtils.getBoolean(this.getComponent(3));
    }

    public String getAccepted() {
        return this.getComponent3();
    }

    public Boolean getAcceptedAsBoolean() {
        return this.getComponent3AsBoolean();
    }

    public String getComponent4() {
        return this.getComponent(4);
    }

    public String getError() {
        return this.getComponent4();
    }

    public Field281 setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field281 setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getTime3(component1));
        return this;
    }

    public Field281 setOutputTime(String component1) {
        return this.setComponent1(component1);
    }

    public Field281 setOutputTime(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field281 setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field281 setComponent2(MOR component2) {
        this.setComponent(2, SwiftFormatUtils.getMOR(component2));
        return this;
    }

    public Field281 setMOR(String component2) {
        return this.setComponent2(component2);
    }

    public Field281 setMOR(MOR component2) {
        return this.setComponent2(component2);
    }

    public Field281 setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field281 setComponent3(Boolean component3) {
        this.setComponent(3, SwiftFormatUtils.getBoolean(component3));
        return this;
    }

    public Field281 setAccepted(String component3) {
        return this.setComponent3(component3);
    }

    public Field281 setAccepted(Boolean component3) {
        return this.setComponent3(component3);
    }

    public Field281 setComponent4(String component4) {
        this.setComponent(4, component4);
        return this;
    }

    public Field281 setError(String component4) {
        return this.setComponent4(component4);
    }

    @Override
    public String getName() {
        return "281";
    }

    public static Field281 get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("281");
        if (t == null) {
            return null;
        }
        return new Field281(t);
    }

    public static Field281 get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field281.get(msg.getBlock4());
    }

    public static List<Field281> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field281.getAll(msg.getBlock4());
    }

    public static List<Field281> getAll(SwiftTagListBlock block) {
        ArrayList<Field281> result = new ArrayList<Field281>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("281");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field281(f));
            }
        }
        return result;
    }

    public static Field281 fromJson(String json) {
        Field281 field = new Field281();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("outputTime") != null) {
            field.setComponent1(jsonObject.get("outputTime").getAsString());
        }
        if (jsonObject.get("mOR") != null) {
            field.setComponent2(jsonObject.get("mOR").getAsString());
        }
        if (jsonObject.get("accepted") != null) {
            field.setComponent3(jsonObject.get("accepted").getAsString());
        }
        if (jsonObject.get("error") != null) {
            field.setComponent4(jsonObject.get("error").getAsString());
        }
        return field;
    }
}

