/*
 * Decompiled with CFR 0.152.
 */
package com.prowidesoftware.swift.model.field;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.prowidesoftware.swift.model.SwiftMessage;
import com.prowidesoftware.swift.model.SwiftTagListBlock;
import com.prowidesoftware.swift.model.Tag;
import com.prowidesoftware.swift.model.field.DateContainer;
import com.prowidesoftware.swift.model.field.DateResolver;
import com.prowidesoftware.swift.model.field.Field;
import com.prowidesoftware.swift.model.field.SwiftParseUtils;
import com.prowidesoftware.swift.utils.SwiftFormatUtils;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class Field31W
extends Field
implements Serializable,
DateContainer {
    public static final int SRU = 2025;
    private static final long serialVersionUID = 1L;
    public static final String NAME = "31W";
    public static final String F_31W = "31W";
    public static final Integer DATE = 1;
    public static final Integer SOURCE = 2;

    public Field31W() {
        super(3);
    }

    public Field31W(String value) {
        super(value);
    }

    public Field31W(Tag tag) {
        this();
        if (tag == null) {
            throw new IllegalArgumentException("tag cannot be null.");
        }
        if (!StringUtils.equals((CharSequence)tag.getName(), (CharSequence)"31W")) {
            throw new IllegalArgumentException("cannot create field 31W from tag " + tag.getName() + ", tagname must match the name of the field.");
        }
        this.parse(tag.getValue());
    }

    public static Field31W newInstance(Field31W source) {
        Field31W cp = new Field31W();
        cp.setComponents(new ArrayList<String>(source.getComponents()));
        return cp;
    }

    public static Tag tag(String value) {
        return new Tag("31W", value);
    }

    public static Tag emptyTag() {
        return new Tag("31W", "");
    }

    @Override
    public void parse(String value) {
        this.init(3);
        this.setComponent1(SwiftParseUtils.getTokenFirst(value, "/"));
        this.setComponent2(SwiftParseUtils.getTokenSecondLast(value, "/"));
    }

    @Override
    public String getValue() {
        StringBuilder result = new StringBuilder();
        this.append(result, 1);
        result.append("/");
        this.append(result, 2);
        return result.toString();
    }

    @Override
    public String getValueDisplay(int component, Locale locale) {
        Calendar cal;
        DateFormat f;
        if (component < 1 || component > 3) {
            throw new IllegalArgumentException("invalid component number " + component + " for field 31W");
        }
        if (component == 1) {
            f = DateFormat.getDateInstance(2, this.notNull(locale));
            cal = this.getComponent1AsCalendar();
            if (cal != null) {
                return f.format(cal.getTime());
            }
        }
        if (component == 2) {
            return this.getComponent(2);
        }
        f = new SimpleDateFormat("HH:mm", this.notNull(locale));
        cal = this.getComponent3AsCalendar();
        if (cal != null) {
            return f.format(cal.getTime());
        }
        return null;
    }

    @Override
    public String typesPattern() {
        return "DSH";
    }

    @Override
    public String parserPattern() {
        return "S/S";
    }

    @Override
    public String validatorPattern() {
        return "<DATE4>/4!c(**)";
    }

    @Override
    public boolean isOptional(int component) {
        return false;
    }

    @Override
    public boolean isGeneric() {
        return false;
    }

    @Override
    public int componentsSize() {
        return 3;
    }

    @Override
    public List<String> getComponentLabels() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("Date");
        result.add("Source");
        result.add(null);
        return result;
    }

    @Override
    protected Map<Integer, String> getComponentMap() {
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        result.put(1, "date");
        result.put(2, "source");
        return result;
    }

    @Override
    protected Map<String, Integer> getLabelMap() {
        if (this.labelMap != null && !this.labelMap.isEmpty()) {
            return this.labelMap;
        }
        this.labelMap = new HashMap<String, Integer>();
        this.labelMap.put("date", 1);
        this.labelMap.put("source", 2);
        return this.labelMap;
    }

    public String getComponent1() {
        return this.getComponent(1);
    }

    public Calendar getComponent1AsCalendar() {
        return SwiftFormatUtils.getDate4(this.getComponent(1));
    }

    public String getDate() {
        return this.getComponent1();
    }

    public Calendar getDateAsCalendar() {
        return this.getComponent1AsCalendar();
    }

    public String getComponent2() {
        return this.getComponent(2);
    }

    public String getSource() {
        return this.getComponent2();
    }

    public String getComponent3() {
        return this.getComponent(3);
    }

    public Calendar getComponent3AsCalendar() {
        return SwiftFormatUtils.getTime3(this.getComponent(3));
    }

    public Field31W setComponent1(String component1) {
        this.setComponent(1, component1);
        return this;
    }

    public Field31W setComponent1(Calendar component1) {
        this.setComponent(1, SwiftFormatUtils.getDate4(component1));
        return this;
    }

    public Field31W setDate(String component1) {
        return this.setComponent1(component1);
    }

    public Field31W setDate(Calendar component1) {
        return this.setComponent1(component1);
    }

    public Field31W setComponent2(String component2) {
        this.setComponent(2, component2);
        return this;
    }

    public Field31W setSource(String component2) {
        return this.setComponent2(component2);
    }

    public Field31W setComponent3(String component3) {
        this.setComponent(3, component3);
        return this;
    }

    public Field31W setComponent3(Calendar component3) {
        this.setComponent(3, SwiftFormatUtils.getTime3(component3));
        return this;
    }

    @Override
    public List<Calendar> dates() {
        return DateResolver.dates(this);
    }

    public Calendar date() {
        return DateResolver.date(this);
    }

    @Override
    public String getName() {
        return "31W";
    }

    public static Field31W get(SwiftTagListBlock block) {
        if (block == null || block.isEmpty()) {
            return null;
        }
        Tag t = block.getTagByName("31W");
        if (t == null) {
            return null;
        }
        return new Field31W(t);
    }

    public static Field31W get(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return null;
        }
        return Field31W.get(msg.getBlock4());
    }

    public static List<Field31W> getAll(SwiftMessage msg) {
        if (msg == null || msg.getBlock4() == null || msg.getBlock4().isEmpty()) {
            return Collections.emptyList();
        }
        return Field31W.getAll(msg.getBlock4());
    }

    public static List<Field31W> getAll(SwiftTagListBlock block) {
        ArrayList<Field31W> result = new ArrayList<Field31W>();
        if (block == null || block.isEmpty()) {
            return result;
        }
        Tag[] arr = block.getTagsByName("31W");
        if (arr != null) {
            for (Tag f : arr) {
                result.add(new Field31W(f));
            }
        }
        return result;
    }

    public static Field31W fromJson(String json) {
        Field31W field = new Field31W();
        JsonObject jsonObject = JsonParser.parseString((String)json).getAsJsonObject();
        if (jsonObject.get("date") != null) {
            field.setComponent1(jsonObject.get("date").getAsString());
        }
        if (jsonObject.get("source") != null) {
            field.setComponent2(jsonObject.get("source").getAsString());
        }
        return field;
    }
}

